% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_cube.R
\name{gen_cube}
\alias{gen_cube}
\title{Get the Data of a Cube From GENESIS}
\usage{
gen_cube(name, ...)
}
\arguments{
\item{name}{Name of the data cube}

\item{...}{Optional parameters passed on to the GENESIS API call:
\describe{
\item{\code{area}}{a string. The area in which the table is stored. Possible values:
\itemize{
\item \code{"public"}: cube in the public catalogue
\item \code{"user"}: cube in the user's account
}}
\item{\code{values}}{a logical. Should values be included?}
\item{\code{metadata}}{a logical. Should metadata be included?}
\item{\code{additionals}}{a logical. Should additional metadata be included?}
\item{\code{contents}}{a string. Names of required statistical specifications}
\item{\code{startyear,endyear}}{a number. Only retrieve data between these years.}
\item{\code{timeslices}}{a number. Number of timeslices (cumulative to startyear or endyear)}
\item{\code{regionalvariable}}{character. Code of the regional variable
whose value is specified in \code{regionalkey} to filter the results.}
\item{\code{regionalkey}}{character. One or more regional keys. Multiple
values can be supplied as a character vector or as a single string,
with the regional keys separated by commas. Use of wildcard (\code{*}) allowed.}
\item{\code{classifyingvariable1,classifyingvariable2
      ,classifyingvariable3}}{character. Code of the subject classification
(SK-Merkmal) to which the selection by means of the corresponding
\code{classifyingkey} parameter is to be applied.}
\item{\code{classifyingkey1,classifyingkey2,classifyingkey3}}{character.
One or more values of a subject classification (e.g. "WZ93012"). Applied
to the corresponding \code{classifyingvariable} parameter. Multiple
keys can be supplied as a character vector or as a single string,
with the keys separated by commas. Use of wildcard (\code{*}) allowed.}
\item{\code{stand}}{a string \code{"DD.MM.YYYY"}. Only retrieve data
updated after this #' date.}
\item{\code{language}}{Search terms, returned messages and data
descriptions in German (\code{"de"}) or English (\code{"en"})?}
}}
}
\value{
A \link[tibble:tibble]{tibble}. Non-data contents of the data cube object are saved in
the \code{metadata} \link[base:attr]{attribute} of the data frame.
}
\description{
Download a cube with data from GENESIS.
}
\examples{
\dontrun{
gen_cube("47414BJ002")
}

}
