% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_alternative_terms.R
\name{gen_alternative_terms}
\alias{gen_alternative_terms}
\title{Search for Related Terms Based on the Same Specific String}
\usage{
gen_alternative_terms(term = NULL, similarity = TRUE, ...)
}
\arguments{
\item{term}{Character string. Maximum length of 15 characters. Term or word for which you are searching for alternative or related terms. Use of '*' as a placeholder is possible to generate broader search areas.}

\item{similarity}{Logical. Indicator if the output of the function should be sorted based on a Levenshtein edit distance based on the \code{adist()} function.}

\item{...}{Additional parameter of the GENESIS API call. These parameters are only affecting the GENESIS API call itself, no further processing.}
}
\value{
A list with all recalled elements from GENESIS. Attributes are added to the data.frame, describing the search configuration for the returned output.
}
\description{
Function to find terms in GENESIS that are similar or related based on a simple comparison of strings. This can help to identify alternative search terms.
}
\examples{
\dontrun{
# Find terms that are similar (in spelling) to search term "bus"
# and sort them by Levenshtein edit distance
object <- gen_alternative_terms(term = "bus", similarity = TRUE)

# Find terms that are related (in spelling) to search term "bus"
object <- gen_alternative_terms(term = "bus*", similarity = TRUE)
}

}
