% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_geneSymbol.R
\name{refseq_geneSymbol}
\alias{refseq_geneSymbol}
\title{Get the gene symbol}
\usage{
refseq_geneSymbol (id, db)
}
\arguments{
\item{id}{A character string of the transcript or protein id.}

\item{db}{A character string of the "nuccore" or "protein" database.}
}
\value{
A character vector containing the gene symbol corresponding to the especified accession as \code{id}.
}
\description{
\code{refseq_geneSymbol()} Returns the gene symbol from a single Gene id. accession.
}
\examples{
# Get the gene symbol from a set of transcript accessions
id = c("XM_004487701", "XM_004488493")
sapply(id, function(x) refseq_geneSymbol (x, db = "nuccore"), USE.NAMES = FALSE)

# Get the gene symbol from a set of XP accessions
id = c("XP_004487758")
sapply(id, function(x) refseq_geneSymbol (x, db = "protein"), USE.NAMES = FALSE)

}
\seealso{
\code{\link{refseq_protein2RNA}} to obtain the transcript ids that encode a set of protein ids.

\code{\link{refseq_RNA2protein}} to obtain the protein ids encoded by a set of transcript ids.
}
\author{
Jose V. Die
}
