% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{updateReactable}
\alias{updateReactable}
\title{Update a reactable instance}
\usage{
updateReactable(
  outputId,
  selected = NULL,
  expanded = NULL,
  page = NULL,
  session = NULL
)
}
\arguments{
\item{outputId}{The Shiny output ID of the \code{reactable} instance.}

\item{selected}{Selected rows. Either a numeric vector of row indices,
or \code{NA} to deselect all rows.}

\item{expanded}{Expanded rows. Either \code{TRUE} to expand all rows, or \code{FALSE}
to collapse all rows.}

\item{page}{The current page. A single, positive integer.}

\item{session}{The Shiny session object. Defaults to the current Shiny session.}
}
\value{
None
}
\description{
\code{updateReactable()} updates a reactable instance within a Shiny application.
}
\examples{
# Run in an interactive R session
if (interactive()) {

library(shiny)
library(reactable)

ui <- fluidPage(
  actionButton("select_btn", "Select rows"),
  actionButton("clear_btn", "Clear selection"),
  actionButton("expand_btn", "Expand rows"),
  actionButton("collapse_btn", "Collapse rows"),
  actionButton("page_btn", "Change page"),
  reactableOutput("table")
)

server <- function(input, output) {
  output$table <- renderReactable({
    reactable(
      iris,
      selection = "multiple",
      details = function(index) paste("Details for row:", index)
    )
  })

  observeEvent(input$select_btn, {
    # Select rows
    updateReactable("table", selected = c(1, 3, 5))
  })

  observeEvent(input$clear_btn, {
    # Clear row selection
    updateReactable("table", selected = NA)
  })

  observeEvent(input$expand_btn, {
    # Expand all rows
    updateReactable("table", expanded = TRUE)
  })

  observeEvent(input$collapse_btn, {
    # Collapse all rows
    updateReactable("table", expanded = FALSE)
  })

  observeEvent(input$page_btn, {
    # Change current page
    updateReactable("table", page = 3)
  })
}

shinyApp(ui, server)
}

}
