% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\name{wd_download}
\alias{wd_download}
\title{Fetches a file or directory (recursively) from the WebDAV server}
\usage{
wd_download(req, source, target = "")
}
\arguments{
\item{req}{request handle obtained from \code{\link{wd_connect}}}

\item{source}{path to source file or directory on server}

\item{target}{path to local target file or directory, if omitted the file or
directory name will be used, if source is a file and target a directory
then the file will be put into the target directory}
}
\value{
vector of downloaded files (invisibly)
}
\description{
Directories are downloaded recursively.
If the source is a file and the target a directory, then the file is
downloaded to the target directory.
If the target is omitted, then the file or directory name
(\code{\link[base]{basename}}) will be used.
}
\examples{
\dontrun{

wd_download(r, "weatherfiles", "d:/data/weather")
wd_download(r, "test/xyz.txt", "d:/data/abc.txt")

}
}
