% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd2d_dist.R
\name{summary.rd2d.dist}
\alias{summary.rd2d.dist}
\title{Summary Method for 2D Local Polynomial RD Estimation (Distance-Based)}
\usage{
\method{summary}{rd2d.dist}(object, ...)
}
\arguments{
\item{object}{An object of class \code{rd2d.dist}, returned by \code{\link{rd2d.dist}}.}

\item{...}{Optional arguments. Supported options include:
\itemize{
\item \code{CBuniform}: Logical. If \code{TRUE}, displays uniform confidence bands;
if \code{FALSE} (default), displays pointwise confidence intervals.
\item \code{subset}: Integer vector of indices of evaluation points to display.
Defaults to all evaluation points.
\item \code{output}: Character. Use \code{"main"} to display estimation results,
or \code{"bw"} to display bandwidth information. Default is \code{"main"}.
\item \code{sep}: Integer vector of length three. Controls spacing in the output.
\code{sep[1]} controls spacing for the columns of boundary points, estimation,
z-value, and p-value in the \code{"main"} table.
\code{sep[2]} controls spacing for confidence intervals (or bands) in the \code{"main"} table.
\code{sep[3]} controls spacing for the columns in the \code{"bw"} table.
Default is \code{c(7, 17, 8)}.
}}
}
\value{
No return value. This function is called for its side effects: it prints a formatted summary of \code{\link{rd2d.dist}} results.
}
\description{
Summarizes estimation and bandwidth results from a 2D local polynomial regression discontinuity (RD) design using distance-based methods, as returned by \code{\link{rd2d.dist}}.
}
\seealso{
\code{\link{rd2d.dist}} for estimation using distance-based 2D local polynomial RD design.

Supported methods: \code{\link{print.rd2d.dist}}, \code{\link{summary.rd2d.dist}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu} \cr
Rocío Titiunik, Princeton University. \email{titiunik@princeton.edu} \cr
Ruiqi Rae Yu, Princeton University. \email{rae.yu@princeton.edu}
}
