% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_exporter_overview}
\alias{rba_reactome_exporter_overview}
\title{Get a Reactome Pathway Overview}
\usage{
rba_reactome_exporter_overview(
  species,
  output_format = "png",
  save_to = NULL,
  image_quality = 5,
  flag_element = NULL,
  flg_interactors = TRUE,
  sel = NULL,
  title = TRUE,
  margin = 15,
  diagram_profile = "Copper",
  token = NULL,
  resource = "TOTAL",
  exp_column = NULL,
  coverage = FALSE,
  ...
)
}
\arguments{
\item{species}{Numeric or Character: NCBI Taxonomy identifier (Human Taxonomy
ID is 9606.) or species name (e.g. "Homo sapiens"). See
\code{\link{rba_reactome_species}} or
\href{https://reactome.org/content/schema/objects/Species/}{Reactome
Data Schema: Entries: Species}.}

\item{output_format}{Images format, Can be one of: png (default), jpeg,
svg or gif.}

\item{save_to}{NULL or Character:\itemize{
\item NULL: Save the file to an automatically-generated path.
\item Character string: A valid file path to save the file to.}}

\item{image_quality}{Numeric: A number  ranging from 1 to 10. 1 is the
lowest quality and 10 is the highest (default = 5).}

\item{flag_element}{Gene name, protein ID, chemical ID or Reactome ID of a
diagram's element to be flagged.}

\item{flg_interactors}{Logical: Should the interactor be considered when
flagging a diagram element? (default = TRUE)}

\item{sel}{CSV line for highlighting element(s) selection in the diagram.}

\item{title}{Logical: Should the pathway name be displayed below the image?
(default = TRUE)}

\item{margin}{Numeric: A number ranging from 0 to 20 to set as the image's
margin. (default = 15)}

\item{diagram_profile}{Color profile of diagrams, should be one of "Copper"
(default), "Copper Plus", "Barium Lithium" or "calcium salts".}

\item{token}{The analysis Token for which the results will be overlaid on
top of the given pathways overview. see:
\code{\link{rba_reactome_analysis}}.}

\item{resource}{The analysis resource for which the results will be
overlaid on top of the given pathways overview.}

\item{exp_column}{numeric: (only if token is supplied) Specify the
expression column for the overlay.}

\item{coverage}{Logical: Should the analysis coverage values be overlaid?
(default = FALSE)}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
NULL, Based to the inputs, an image file will be saved to disk.
}
\description{
This function will Save a Pathway Overview of the supplied specie
  as an image file.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/exporter/fireworks/\{species\}.\{ext\}"
}

\examples{
\dontrun{
rba_reactome_exporter_overview(species = 9606,
    output_format = "svg",
    save_to = "human_pathways.svg")
}
\dontrun{
rba_reactome_exporter_overview(species = 9606,
    token = 123456789)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
\code{\link{rba_reactome_analysis}}

Other "Reactome Content Service - Format Exporter": 
\code{\link{rba_reactome_exporter_diagram}()},
\code{\link{rba_reactome_exporter_event}()},
\code{\link{rba_reactome_exporter_reaction}()}
}
\concept{"Reactome Content Service - Format Exporter"}
