% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/java_manage.R
\name{java_clear}
\alias{java_clear}
\title{Manage Java installations and distributions caches}
\usage{
java_clear(
  type = c("project", "installed", "distrib"),
  target_dir = NULL,
  check = TRUE,
  delete_all = FALSE
)
}
\arguments{
\item{type}{What to clear: "project" - remove symlinks to install cache in the current project, "installed" - remove installed Java versions, "distrib" - remove downloaded Java distributions.}

\item{target_dir}{The directory to clear. Defaults to current working directory for "project" and user-specific data directory for "installed" and "distrib". Not recommended to change.}

\item{check}{Whether to list the contents of the cache directory before clearing it. Defaults to TRUE.}

\item{delete_all}{Whether to delete all items without prompting. Defaults to FALSE.}
}
\value{
A message indicating whether the cache was cleared or not.
}
\description{
Wrapper function to clear the Java symlinked in the current project, installed, or distributions caches.
}
\examples{
\dontrun{
java_clear("project", target_dir = tempdir())
java_clear("installed", target_dir = tempdir())
java_clear("distrib", target_dir = tempdir())
}

}
