!
!	implicit logical (a-z)
****************************************************************************************
      subroutine BDATFormTarif(Tarif,BDATBArtNr,D,H,MwQ03BWI)
!	****************************************************************************************

!		MwQ03BWI = F(D,H)
!
! 		BDATBArtNr	INT*4	EIN	- BDAT BaumArt Nummer 1-36
!  		D			real EIN	- BHD [cm]
! 		H			real EIN	- BaumH�he [m]
! 		MwQ03BWI	real AUS - Mittelwert q0.3 (gesch�tzt)
!
!	****************************************************************************************

      	INTEGER Tarif
      	INTEGER BDATBArtNr
      	real D, H
      	real MwQ03BWI

      	call xBDATFormTarif(Tarif,BDATBArtNr,D,H,MwQ03BWI)

      end subroutine BDATFormTarif


!	****************************************************************************************
      real Function FNBDATFormTarif(Tarif,BDATBArtNr,D,H,MwQ03BWI)
!	****************************************************************************************

!		MwQ03BWI = F(D,H)
!
!		BDATBArtNr	INT*4	EIN	- BDAT BaumArt Nummer 1-36
! 		D			real EIN	- BHD [cm]
!		H			real EIN	- BaumH�he [m]
!		MwQ03BWI	real AUS - Mittelwert q0.3 (gesch�tzt)
!
!	****************************************************************************************

      	INTEGER Tarif
      	INTEGER BDATBArtNr
      	real D, H
      	real MwQ03BWI

      	call xBDATFormTarif(Tarif, BDATBArtNr,D,H,MwQ03BWI)


      	FNBDATFormTarif = MwQ03BWI

      end function FNBDATFormTarif


!	****************************************************************************************
      subroutine xBDATFormTarif(Tarif,BDATBArtNr,D,H,MwQ03BWI)
!	****************************************************************************************
      implicit logical (a-z)
!		MwQ03BWI = F(D,H)
!
!		BDATBArtNr	INT*4	EIN	- BDAT BaumArt Nummer 1-36
! 		D			real EIN	- BHD [cm]
!		H			real EIN	- BaumH�he [m]
!		MwQ03BWI	real AUS - Mittelwert q0.3 (gesch�tzt)
!
!	****************************************************************************************

      	INTEGER Tarif
      	INTEGER BDATBArtNr
      	real D, H
      	real MwQ03BWI

      	real EQP(1:4,1:9,1:2,1:7)

      	INTEGER BDATSKNrList(1:36)

      	INTEGER BDATSKNr
      	INTEGER t,i,j,k,iErr

      	real d03,d005,dummy
      	real Q1, Q2
      	real EQ03

      	real EQ03uG
      	DATA EQ03uG /0.4000/
      	real EQ03oG
      	DATA EQ03oG /0.9800/

      	real a11, a12, a13, h11, h12, H13, D1
      	real a21, a22, a23, h21, h22, H23, D2
      	real Phi

      	real Z1, Z2

      	real eps
      	DATA eps /0.001/

      	real FNBDATDmRHX

!	----------------------------------------------------------------------------------------

      data BDATSKNrList /
     *1,  1,  2,  2,  4,  4,  4,  3,  5,  5,
     *5,  1,  1,  1,  6,  6,  7,  8,  8,  8,
     *6,  6,  6,  6,  6,  9,  6,  6,  6,  6,
     *6,  6,  7,  6,  6,  6/

!	-------------------------------- Stand 23.08.01 ----------------------------------------

      data ((((EQP(t,i,j,k),k=1,7),j=1,2),i=1,9),t=1,4) /
!    ----- BWI1------------------------------------
     1  20, 10, 50, 0.650, 0.875, 0.850, 0.250,
     1  55, 10, 50, 0.525, 0.860, 0.775, 0.000,
     2  20, 10, 50, 0.750, 0.950, 0.860, 0.500,
     2  70, 10, 50, 0.670, 0.875, 0.780, 0.000,
     3  20, 10, 50, 0.650, 0.925, 0.860, 0.300,
     3  70, 10, 50, 0.500, 0.825, 0.700, 0.000,
     4  20, 10, 50, 0.700, 0.800, 0.770, 0.250,
     4  50, 10, 50, 0.700, 0.790, 0.770, 0.000,
     5  20, 10, 50, 0.725, 0.950, 0.875, 0.500,
     5  60, 10, 50, 0.630, 0.875, 0.750, 0.000,
     6  20, 10, 50, 0.700, 0.900, 0.830, 0.750,
     6  60, 10, 50, 0.650, 0.870, 0.820, 0.000,
     7  20, 10, 50, 0.700, 0.850, 0.840, 0.750,
     7  60, 10, 50, 0.675, 0.840, 0.825, 0.000,
     8  20, 10, 50, 0.775, 0.850, 0.810, 1.000,
     8  60, 10, 50, 0.725, 0.800, 0.760, 0.000,
     9  20, 10, 50, 0.700, 0.900, 0.830, 0.750,
     9  60, 10, 50, 0.650, 0.870, 0.820, 0.000,
!    -----------Neue L�nder------------------------
     1  10, 10, 50, 0.700, 0.900, 0.875, 0.250,
     1  70, 10, 50, 0.550, 0.810, 0.760, 0.000,
     2  20, 10, 50, 0.750, 0.950, 0.860, 0.500,
     2  70, 10, 50, 0.670, 0.875, 0.780, 0.000,
     3  20, 10, 50, 0.650, 0.925, 0.860, 0.300,
     3  70, 10, 50, 0.500, 0.825, 0.700, 0.000,
     4  10, 10, 50, 0.710, 0.810, 0.780, 0.250,
     4  70, 10, 50, 0.700, 0.800, 0.760, 0.000,
     5  20, 10, 50, 0.725, 0.950, 0.875, 0.500,
     5  60, 10, 50, 0.630, 0.875, 0.750, 0.000,
     6  10, 10, 50, 0.625, 0.820, 0.800, 0.250,
     6  70, 10, 50, 0.575, 0.810, 0.780, 0.000,
     7  10, 10, 50, 0.650, 0.850, 0.825, 0.250,
     7  70, 10, 50, 0.575, 0.825, 0.800, 0.000,
     8  20, 10, 50, 0.775, 0.850, 0.810, 1.000,
     8  60, 10, 50, 0.725, 0.800, 0.760, 0.000,
     9  10, 10, 50, 0.700, 0.850, 0.825, 0.250,
     9  70, 10, 50, 0.575, 0.725, 0.675, 0.000,
!    ----------- IS08------------------------------
     1    20, 10, 50, 0.494, 0.939, 0.857, 0.250,
     1    70, 10, 50, 0.494, 0.796, 0.729, 0.000,
     2    20, 10, 50, 0.665, 0.870, 0.838, 0.500,
     2    80, 10, 50, 0.593, 0.827, 0.745, 0.000,
     3    20, 10, 50, 0.519, 0.782, 0.768, 0.500,
     3    80, 10, 50, 0.467, 0.775, 0.755, 0.000,
     4    10, 10, 50, 0.674, 0.784, 0.770, 0.250,
     4    70, 10, 50, 0.650, 0.780, 0.761, 0.000,
     5    10, 10, 50, 0.689, 0.833, 0.813, 0.500,
     5    60, 10, 50, 0.417, 0.813, 0.753, 0.000,
     6    10, 10, 50, 0.467, 0.830, 0.806, 0.250,
     6    70, 10, 50, 0.400, 0.818, 0.781, 0.000,
     7    10, 10, 50, 0.586, 0.861, 0.827, 0.250,
     7    70, 10, 50, 0.482, 0.827, 0.793, 0.000,
     8    20, 10, 50, 0.775, 0.850, 0.810, 1.000,
     8    60, 10, 50, 0.725, 0.800, 0.760, 0.000,
     9    10, 10, 50, 0.454, 0.912, 0.812, 0.250,
     9    70, 10, 50, 0.502, 0.737, 0.680, 0.000,
!    ------------BWI3------------------------------------
     1    20, 10, 50, 0.6420103, 0.888355, 0.8613915, 0.25,
     1    70, 10, 50, 0.4607479, 0.8679195, 0.7564586, 0.25,
     2    20, 10, 50, 0.7549, 0.9659322, 0.8680001, 0.5,
     2    80, 10, 50, 0.6573403, 0.8762392, 0.7838848, 0.5,
     3    20, 10, 50, 0.6397411, 0.8182462, 0.7964373, 0.5,
     3    80, 10, 50, 0.4664799, 0.7925813, 0.7392171, 0.5,
     4    10, 10, 50, 0.7204486, 0.967768, 0.7891799, 1,
     4    70, 10, 50, 0.7319144, 0.8527102, 0.7562992, 1,
     5    10, 10, 50, 0.788315, 0.8702361, 0.8701137, 0.5,
     5    60, 10, 50, 0.4612521, 0.8376158, 0.7608057, 0.5,
     6    10, 10, 50, 0.6985465, 0.8321258, 0.7983484, 0.25,
     6    70, 10, 50, 0.6078472, 0.8996977, 0.8125365, 0.25,
     7    10, 10, 50, 0.6925529, 0.8351468, 0.8111729, 0.25,
     7    70, 10, 50, 0.6565229, 0.8682255, 0.8281585, 0.25,
     8    20, 10, 50, 0.7684993, 0.9120466, 0.7992741, 1,
     8    60, 10, 50, 0.7262412, 0.8523916, 0.7576412, 1,
     9    10, 10, 50, 0.6772199, 0.962364, 0.8331439, 0.25,
     9    70, 10, 50, 0.5566832, 0.9492619, 0.7215377, 0.25 /







!	----------------------------------------------------------------------------------------
      	if(Tarif .lt. 0 .or. Tarif .gt.4) then
      		Tarif=1
      	endif

      	if (Tarif .eq. 0) then

      	d03 =FNBDATDmRHx(BdatBartNr,D,0.0,0.0,0.0,H,H*0.3, IErr, dummy)
      	d005=FNBDATDmRHx(BdatBartNr,D,0.0,0.0,0.0,H,H*0.05,IErr, dummy)
      	EQ03=d03/d005

      	else

      	BDATSKNr = BDATSKNrList(BDATBArtNr)

      	a11 = EQP(Tarif,BDATSKNr, 1, 4)
      	a12 = EQP(Tarif,BDATSKNr, 1, 5)
      	a13 = EQP(Tarif,BDATSKNr, 1, 6)

      	h11 = EQP(Tarif,BDATSKNr, 1, 2)
      	h12 = EQP(Tarif,BDATSKNr, 1, 3)
      	H13 = (h12 + h11) * 0.5

      	D1 = EQP(Tarif,BDATSKNr, 1, 1)

      	a21 = EQP(Tarif,BDATSKNr, 2, 4)
      	a22 = EQP(Tarif,BDATSKNr, 2, 5)
      	a23 = EQP(Tarif,BDATSKNr, 2, 6)

      	h21 = EQP(Tarif,BDATSKNr, 2, 2)
      	h22 = EQP(Tarif,BDATSKNr, 2, 3)
      	H23 = (h22 + h21) * 0.5

      	D2 = EQP(Tarif,BDATSKNr, 2, 1)

      	Phi = EQP(Tarif,BDATSKNr, 1, 7)

!     ****************************************************************************************
!    	* Z(H|D(i)) = MW [Q0.3| H | a(H(i,j)|D(i))]; j=1,2,3; i=1,2                            *
!	* Ratkowsky, D.A. (1990) (4.3.9), S97                                                  *
!     ****************************************************************************************

      	Q1 = 2 * (H - h11) / (h12 - h11)
      	Z1 = a11 + (a12 - a11)
     1      * (1 - ((a12 - a13)/(a13 - a11))** Q1)
     2      / (1 - ((a12 - a13) / (a13 - a11)) ** 2)

      	Q2 = 2 * (H - h21) / (h22 - h21)
      	Z2 = a21 + (a22 - a21)
     1      * (1 - ((a22 - a23)/(a23 - a21)) ** Q2)
     2      / (1 - ((a22 - a23) / (a23 - a21)) ** 2)

!     ****************************************************************************************
!     * EQ0.3(D,H) =  E [Q0.3| D, Z(H|D(i)); i=1,2] * Ratkowsky, D.A. (1990) (4.3.23), S104  *
!     ****************************************************************************************

      	EQ03 = Z1 * Z2 * (D2 ** Phi - D1 ** Phi)
     1      / (Z2 * (D2 ** Phi - D ** Phi)
     2      + Z1 * (D ** Phi - D1 ** Phi))

      	If (EQ03 < EQ03uG) Then
      		EQ03 = EQ03uG
      	End If

      	If (EQ03 > EQ03oG) Then
      		EQ03 = EQ03oG
      	End If

      	End If

!		***************
      	MwQ03BWI = EQ03
!		***************

      end subroutine xBDATFormTarif
