% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{sum_if}
\alias{sum_if}
\title{Sum Conditional on Minimum Frequency of Observed Values}
\usage{
sum_if(x, impute = TRUE, ov.min = 1, prop = TRUE, inclusive = TRUE)
}
\arguments{
\item{x}{numeric or logical vector.}

\item{impute}{logical vector of length 1 specifying if missing values should
be imputed with the mean of observed values of \code{x}. If TRUE (default),
this will make sums over the same vectors with different amounts of missing
data comparable.}

\item{ov.min}{minimum frequency of observed values required. If \code{prop} =
TRUE, then this is a decimal between 0 and 1. If \code{prop} = FALSE, then
this is a integer between 0 and \code{length(x)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the sum should
be calculated (rather than NA) if the frequency of observed values is
exactly equal to \code{ov.min}.}
}
\value{
numeric vector of length 1 providing the sum of \code{x} or \code{NA}
  conditional on if the frequency of observed data is greater than (or equal
  to) \code{ov.min}.
}
\description{
\code{sum_if} calculates the sum of a numeric or logical vector conditional
on a specified minimum frequency of observed values. If the amount of
observed data is less than (or equal to) \code{ov.min}, then \code{NA} is
returned rather than the sum.
}
\examples{
sum_if(x = airquality[[1]], ov.min = .75) # proportion of observed values
sum_if(x = airquality[[1]], ov.min = 116,
   prop = FALSE) # count of observe values
sum_if(x = airquality[[1]], ov.min = 116, prop = FALSE,
   inclusive = FALSE) # not include ov.min value itself
sum_if(x = c(TRUE, NA, FALSE, NA),
   ov.min = .50) # works with logical vectors as well as numeric
}
\seealso{
\code{\link{sum}}
   \code{\link{mean_if}}
   \code{\link{make.fun_if}}
}
