% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{.cronbachs}
\alias{.cronbachs}
\title{Bootstrap Function for \code{cronbachs()} Function}
\usage{
.cronbachs(dat, i, nm.list, use)
}
\arguments{
\item{dat}{data.frame of data. It can contain variables other than those used
for cronbach's alpha calculation.}

\item{i}{integer vector of length = \code{nrow(dat)} specifying which rows
should be included in the computation. When used by the \code{boot::boot}
function this argument will change with every new bootstrapped resample.}

\item{nm.list}{list of character vectors specifying the sets of
variables/items associated with each of the cronbach's alpha calculations.}

\item{use}{character vector of length 1 specifying how missing data should be
handled when computing covariances. See \code{cov} for details.}
}
\value{
double vector of length = \code{length(nm.list)} providing cronbach's
  alpha for each set of variables/items.
}
\description{
\code{.cronbachs} is the function used by the \code{\link[boot]{boot}}
function within the \code{cronbachs} function. It is primarily created to
increase the computational efficiency of bootstrap confidence intervals
within the \code{cronbachs} function by doing only the minimal computations
needed to compute cronbach's alpha for each set of variables/items.
}
\examples{

dat0 <- psych::bfi[1:250, ]
dat1 <- str2str::pick(x = dat0, val = c("A1","C4","C5","E1","E2","O2","O5",
   "gender","education","age"), not = TRUE, nm = TRUE)
vrb_nm_list <- lapply(X = str2str::sn(c("E","N","C","A","O")), FUN = function(nm) {
   str2str::pick(x = names(dat1), val = nm, pat = TRUE)})
.cronbachs(dat = dat1,
   i = sample(x = 1:nrow(dat1), size = nrow(dat1), replace = TRUE),
   nm.list = vrb_nm_list, use = "pairwise")
}
