% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quax.R
\name{summary.quax}
\alias{summary.quax}
\title{Summarizing quantile regression fits of potential regeneration densities}
\usage{
\method{summary}{quax}(object, ...)
}
\arguments{
\item{object}{The function returned by \code{\link{quax}}.}

\item{...}{not in use here}
}
\value{
A list with the following components:
\describe{
\item{\code{coefficients}}{The parameters of the estimated dispersal kernel.}
\item{\code{value}}{The attained value of the objective function that is
minimised in the quantile regression.}
}
}
\description{
This function is the \code{summary} method for class \code{quax} objects as returned
by \code{\link{quax}}.
}
\details{
The \code{value} component of the result can be used to compare the
quality of the fit of different dispersal kernels for the same quantile
to the same data.
}
\examples{
## Prepare artificial data:
set.seed(0)
r <- rgamma(200, shape=2, scale=150)
simulated.data <- data.frame(distance = r, density =
  rpois(length(r), k_lognormal(r, par=c(6,0), N=1000000, d=2)))
plot(density ~ distance, simulated.data)

## Fit a log-normal and a power-law dispersal kernel to the data:
f1 <- quax(density ~ distance, simulated.data,
  tau = 0.9, fun = k_lognormal)
f2 <- quax(density ~ distance, simulated.data,
  tau = 0.9, fun = k_power)

## Compare both fits:
summary(f1)
summary(f2)
}
