% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_dist.R
\name{extract_dist}
\alias{extract_dist}
\title{Extracting distances to nearest seed source for point data}
\usage{
extract_dist(raster, geom, species)
}
\arguments{
\item{raster}{Raster dataset with tree species classification of specific
tree species and tree species groups.}

\item{geom}{Geodata representing the study area. This can be a polygon
or point dataset. This describes the outer boundary of the study area.
A buffer of 1000 m is placed around the Bounding box to possibly take into
account seed trees outside the study area.}

\item{species}{Represents the numerical value by which the tree species
of interest was encoded in the raster dataset.}
}
\value{
Numeric vector with distances of every inventory plot to the
nearest seed source of a specific tree species.
}
\description{
Extracts a distance for the inventory plots. The distance to the
nearest seed source is used for the analysis of the regeneration potential.
}
\examples{
## Create raster data set
set.seed(2023)
rr <- terra::rast(
matrix(sample(0:10, 20 * 20, replace = TRUE),
        nrow = 20, ncol = 20))

## Create vector data set
vec <- terra::vect(rbind(c(5,10), c(5,15)))

## Extract distance for the inventory plot
extract_dist(raster=rr, geom=vec, species=10)
}
