% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gutenberg_data.R
\name{get_gutenberg_data}
\alias{get_gutenberg_data}
\title{Get Works from Project Gutenberg}
\usage{
get_gutenberg_data(
  target_dir,
  lcc_subject,
  birth_year = NULL,
  death_year = NULL,
  n_works = 100,
  force = FALSE,
  confirmed = FALSE
)
}
\arguments{
\item{target_dir}{The directory where the CSV file will be saved.}

\item{lcc_subject}{A character vector specifying the Library of Congress
Classification (LCC) subjects to filter the works.}

\item{birth_year}{An optional integer specifying the minimum birth year of
authors to include.}

\item{death_year}{An optional integer specifying the maximum death year of
authors to include.}

\item{n_works}{An integer specifying the number of works to retrieve.
Default is 100.}

\item{force}{A logical value indicating whether to overwrite existing data
if it already exists.}

\item{confirmed}{If \code{TRUE}, the user has confirmed that they have
permission to use the data.
If \code{FALSE}, the function will prompt the user to confirm permission.
Setting this to \code{TRUE} is useful for reproducible workflows.}
}
\value{
A message indicating whether the data was acquired or already
existed on disk, writes the data files to disk in the specified target
directory.
}
\description{
Retrieves works from Project Gutenberg based on specified criteria
and saves the data to a CSV file. This function is a wrapper for the
gutenbergr package.
}
\details{
This function retrieves Gutenberg works based on the specified LCC
subjects and optional author birth and death years.
It checks if the data already exists in the target directory and provides
an option to overwrite it.
The function also creates the target directory if it doesn't exist.
If the number of works is greater than 1000 and the 'confirmed' parameter
is not set to TRUE, it prompts the user for confirmation.
The retrieved works are filtered based on public domain rights in the USA
and availability of text.
The resulting works are downloaded and saved as a CSV file in the target
directory.

For more information on Library of Congress Classification (LCC) subjects,
refer to the \url{https://www.loc.gov/catdir/cpso/lcco/} Library of
Congress Classification Guide.
}
\examples{
\dontrun{
data_dir <- file.path(tempdir(), "data")

get_gutenberg_data(
  target_dir = data_dir,
  lcc_subject = "JC",
  n_works = 5,
  confirmed = TRUE
)
}

}
