% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pkg_to_bib.R
\name{add_pkg_to_bib}
\alias{add_pkg_to_bib}
\title{Add package to BibTeX file}
\usage{
add_pkg_to_bib(pkg_name, bib_file = "packages.bib")
}
\arguments{
\item{pkg_name}{The name of the package to add to the BibTeX file.}

\item{bib_file}{The name of the BibTeX file to write to.}
}
\description{
This function adds a package to a BibTeX file. It uses the
\code{knitr::write_bib} function to write the package name to the file.
}
\examples{
my_bib_file <- tempfile(fileext = ".bib")
add_pkg_to_bib("dplyr", my_bib_file)
readLines(my_bib_file) |> cat(sep = "\n")

}
