% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr_logo.R
\name{add_logo}
\alias{add_logo}
\title{Add a logo to a QR code}
\usage{
add_logo(
  code,
  logo,
  ecl = c("L", "M", "Q", "H"),
  hjust = c("c", "l", "r"),
  vjust = c("c", "b", "t")
)
}
\arguments{
\item{code}{A \code{qr_code} object}

\item{logo}{the path to a logo image file.
Must be either \code{png}, \code{svg} or \code{jpeg} format.}

\item{ecl}{the required error correction level for the QR code
after overlaying the logo.
Must be lower than the \code{ecl} in the \code{code}.
Defaults to \code{"L"}.
The difference between the \code{ecl} set here and the \code{ecl} in \code{code} determines
the maximum area of the logo.
For the largest logo, generate \code{code} with \code{ecl = "H"} and add the logo with
\code{ecl = "L"}.}

\item{hjust}{Horizontal position of the logo.
The default of \code{"c"} indicates the centre of the QR code.
Use \code{"r"} to align the right side of the logo with the right side of the QR
code.
Use \code{"l"} to align the left side of the logo with the right side of the two
vertical finder patterns.}

\item{vjust}{Vertical position of the logo.
The default of \code{"c"} indicates the centre of the QR code..
Use \code{"b"} to align the bottom of the logo with the bottom of the QR code.
Use \code{"t"} to align the top of the logo with the bottom side of the two
horizontal finder patterns.}
}
\description{
First generate a \code{qr_code} with a higher \code{ecl} level.
Then add the logo.
The maximum area of logo depends on the difference in \code{ecl} level between the
version with and without logo.
The size of the logo is further restricted by its image ratio.
We shrink very wide or tall logos to make sure it still fits on the logo.
}
