% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_cells1.R
\name{px_order}
\alias{px_order}
\alias{px_order.px}
\title{Change value order}
\usage{
px_order(x, value, validate)

\method{px_order}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A data frame with the columns 'order' and one or more of the columns: 'variable-code', and 'code'. If 'value' is missing, the current ORDER is returned. If NULL, ORDER is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or data frame.
}
\description{
Inspect or change ORDER.
}
\examples{
# Set ORDER for a variable
library(tibble)
x1 <-
  population_gl |>
  px() |>
  px_order(tribble(~`variable-code`, ~order,
                       'gender', 8))

# Print ORDER
px_order(x1)

# Set ORDER for a value
x2 <-
  x1 |>
  px_order(tribble(~`variable-code`, ~code, ~order,
                       'age', '2004', 9))
px_order(x2)

# Remove ORDER
x3 <- px_order(x2, NULL)
px_order(x3)
}
