% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_spectral_density.R
\name{MakeCompositePSDForAllWindows}
\alias{MakeCompositePSDForAllWindows}
\title{Make PSD for each window (dataframe) in a list and then find the average of all the PSDs}
\usage{
MakeCompositePSDForAllWindows(
  list.of.windows,
  name.of.col.containing.time.series,
  sampling_frequency,
  x_start = 0,
  x_end,
  x_increment
)
}
\arguments{
\item{list.of.windows}{A list of windows (dataframes).}

\item{name.of.col.containing.time.series}{A string that specifies the name of the column in the windows that correspond to the time series that should be used for making PSD.}

\item{sampling_frequency}{Numeric value specifying sampling frequency in hertz. If data is sampled once every second, then sampling frequency is 1 Hz. If data is sampled once every 2 seconds, then sampling frequency is 0.5 Hz.}

\item{x_start}{Numeric value specifying start of the new x-axis for the averaged PSD. Default is 0 Hz.}

\item{x_end}{Numeric value specifying end of the new x-axis for the averaged PSD. Maximum value is the sampling_frequency divided by 2.}

\item{x_increment}{Numeric value specifying increment of the new x-axis for the averaged PSD.}
}
\value{
A List with two objects:
\enumerate{
\item Vector of frequencies in Hz. The maximum frequency should be half the sampling frequency. Called Nyquist Frequency.
\item Vector of averaged PSD values corresponding with each frequency. Units should be in the original units of the data vector squared and divided by frequency.
\item Vector of standard deviation of PSD values corresponding with each frequency. This can be used to generate error envelopes or error bars to show the variation between windows.
}

The vector of frequencies can be used as the x-axis values of a single sided spectrum amplitude plot.
The vector of PSD values can be used as the y-axis values of the PSD plot.
}
\description{
Given multiple windows of time series data, if the sampling frequency for
all time series is the same, then the PSD for each window can be calculated,
and then averaged to create a composite PSD.
}
\details{
Using fft(), the PSD of a time series dataset can be calculated.This is done
for multiple windows of time using the MakePowerSpectralDensity() function
for each window. When the code executes, a counter is displayed to indicate
how many windows have been analyzed.
}
\examples{
#Create a vector of time that represent times where data are sampled.
Fs = 100; #sampling frequency in Hz
T = 1/Fs; #sampling period
L = 1000; #length of time vector
t = (0:(L-1))*T; #time vector

#First signal
#1. 10 Hz with amplitude of 4
#2. 25 Hz with amplitude of 4
S1 <- 1*sin(2*pi*10*t) + 2*sin(2*pi*25*t);
S1 <- S1 + rnorm(length(t)) #Add some noise
S1.data.frame <- as.data.frame(cbind(t, S1))
colnames(S1.data.frame) <- c("Time", "Signal")

#Second signal
#1. 5 Hz with amplitude of 2
#2. 8 Hz with amplitude of 2
S2 <- 2*sin(2*pi*5*t) + 2*sin(2*pi*8*t);
S2 <- S2 + rnorm(length(t)) #Add some noise
S2.data.frame <- as.data.frame(cbind(t, S2))
colnames(S2.data.frame) <- c("Time", "Signal")

#Third signal
#1. 5 Hz with amplitude of 2
#2. 8 Hz with amplitude of 2
S3 <- 2*sin(2*pi*5*t) + 2*sin(2*pi*8*t);
S3 <- S3 + rnorm(length(t)) #Add some noise
S3.data.frame <- as.data.frame(cbind(t, S3))
colnames(S3.data.frame) <- c("Time", "Signal")

#Add all signals to a List
list.of.windows <- list(S1.data.frame, S2.data.frame, S3.data.frame)

results <- MakeCompositePSDForAllWindows(list.of.windows, "Signal", Fs, 0, 30, 0.1)

frequencies <- results[[1]]

averaged.PSD <- results[[2]]

stddev.PSD <- results[[3]]

#dev.new()
plot(frequencies, averaged.PSD, type = "l")

#dev.new()
plot(frequencies, averaged.PSD, type = "l")
#Add error bars
arrows(frequencies, averaged.PSD, frequencies, averaged.PSD + stddev.PSD, length=0.05, angle=90)
arrows(frequencies, averaged.PSD, frequencies, averaged.PSD - stddev.PSD, length=0.05, angle=90)


}
