% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_map.R
\name{process_map}
\alias{process_map}
\alias{process_map.eventlog}
\alias{process_map.grouped_eventlog}
\alias{process_map.activitylog}
\title{Process Map}
\usage{
process_map(
  log,
  type = frequency("absolute"),
  sec = NULL,
  type_nodes = type,
  type_edges = type,
  sec_nodes = sec,
  sec_edges = sec,
  rankdir = "LR",
  render = T,
  fixed_edge_width = F,
  layout = layout_pm(),
  fixed_node_pos = NULL,
  eventlog = deprecated(),
  ...
)

\method{process_map}{eventlog}(
  log,
  type = frequency("absolute"),
  sec = NULL,
  type_nodes = type,
  type_edges = type,
  sec_nodes = sec,
  sec_edges = sec,
  rankdir = "LR",
  render = T,
  fixed_edge_width = F,
  layout = layout_pm(),
  fixed_node_pos = NULL,
  eventlog = deprecated(),
  ...
)

\method{process_map}{grouped_eventlog}(
  log,
  type = frequency("absolute"),
  sec = NULL,
  type_nodes = type,
  type_edges = type,
  sec_nodes = sec,
  sec_edges = sec,
  rankdir = "LR",
  render = T,
  fixed_edge_width = F,
  layout = layout_pm(),
  fixed_node_pos = NULL,
  eventlog = deprecated(),
  ...
)

\method{process_map}{activitylog}(
  log,
  type = frequency("absolute"),
  sec = NULL,
  type_nodes = type,
  type_edges = type,
  sec_nodes = sec,
  sec_edges = sec,
  rankdir = "LR",
  render = T,
  fixed_edge_width = F,
  layout = layout_pm(),
  fixed_node_pos = NULL,
  eventlog = deprecated(),
  ...
)
}
\arguments{
\item{log}{\code{\link[bupaR:log]{log}}: Object of class \code{\link[bupaR:log]{log}} or derivatives (\code{\link[bupaR:grouped_log]{grouped_log}},
\code{\link[bupaR:eventlog]{eventlog}}, \code{\link[bupaR:activitylog]{activitylog}}, etc.).}

\item{type}{A process map type, which can be created with the functions frequency, performance and custom. The first type focusses on the frequency aspect of a process, while the second one focussed on processing time. The third one allows custom attributes to be used.}

\item{sec}{A secondary process map type. Values are shown between brackets.}

\item{type_nodes}{A process map type to be used for nodes only, which can be created with the functions frequency and performance. The first type focusses on the frequency aspect of a process, while the second one focussed on processing time.}

\item{type_edges}{A process map type to be used for edges only, which can be created with the functions frequency and performance. The first type focusses on the frequency aspect of a process, while the second one focussed on processing time.}

\item{sec_nodes}{A secondary process map type for nodes only.}

\item{sec_edges}{A secondary process map type for edges only.}

\item{rankdir}{The direction in which to layout the graph:  "LR" (default),"TB", "BT", "RL", corresponding to directed graphs drawn from top to bottom, from left to right, from bottom to top, and from right to left, respectively.}

\item{render}{Whether the map should be rendered immediately (default), or rather an object of type dgr_graph should be returned.}

\item{fixed_edge_width}{If TRUE, don't vary the width of edges.}

\item{layout}{List of parameters influencing the (automatic) layout of the process map. Use \code{\link{layout_pm}} to create a suitable parameter list.}

\item{fixed_node_pos}{Deprecated, please use the 'layout' parameter instead.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}

\item{...}{Deprecated arguments}
}
\description{
A function for creating a process map of an event log.
}
\section{Methods (by class)}{
\itemize{
\item \code{process_map(eventlog)}: Process map for event log

\item \code{process_map(grouped_eventlog)}: Process map for event log

\item \code{process_map(activitylog)}: Process map for activitylog

}}
\examples{
\dontrun{
library(eventdataR)
data(patients)
process_map(patients)
}

}
