% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/prime_count.R
\name{prime_count}
\alias{prime_count}
\alias{nth_prime_estimate}
\title{Prime-counting Functions and Estimating the Value of the n-th Prime}
\usage{
prime_count(n, upper_bound)

nth_prime_estimate(n, upper_bound)
}
\arguments{
\item{n}{an integer. See \emph{Details} for more information.}

\item{upper_bound}{a logical indicating whether to estimate the lower- or
upper bound.}
}
\description{
Functions for estimating \eqn{\pi(n)}{pi(n)}---the number of primes less than
or equal to \eqn{n}{n}---and for estimating the value of \eqn{p_n}, the n-th
prime number.
}
\details{
The \code{prime_count} function estimates the number of primes \eqn{\le n}{<= n}.
When \code{upper_bound = FALSE}, it is guaranteed to under-estimate for all
\eqn{n \ge 17}{n >= 17}.
When \code{upper_bound = TRUE}, it holds for all positive \eqn{n}.

The \code{nth_prime_estimate} function brackets upper and lower bound values of
the nth prime. It is valid for \eqn{n \ge 6}{n >= 6}.

The methods of estimation used here are a few of many alternatives. For
further information, the reader is directed to the \emph{References} section.
}
\references{
"Prime-counting function" (2020) \emph{Wikipedia}. \url{https://en.wikipedia.org/wiki/Prime-counting_function#Inequalities} (Accessed 26 Jul 2020).
}
\author{
Paul Egeler, MS
}
