% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angles.R
\name{angles_to_polysph}
\alias{angles_to_polysph}
\alias{polysph_to_angles}
\title{Conversion between the angular and Cartesian coordinates of the
polysphere}
\usage{
angles_to_polysph(theta, d)

polysph_to_angles(x, d)
}
\arguments{
\item{theta}{matrix of size \code{c(n, sum(d))} with the angles.}

\item{d}{vector with the dimensions of the polysphere.}

\item{x}{matrix of size \code{c(n, sum(d + 1))} with the Cartesian
coordinates on \eqn{\mathcal{S}^{d_1}\times\cdots\times\mathcal{S}^{d_r}}.
Assumed to be of unit norm by blocks of coordinates in the rows.}
}
\value{
\itemize{
\item{\code{angles_to_polysph}: the matrix \code{x}.}
\item{\code{polysph_to_angles}: the matrix \code{theta}.}
}
}
\description{
Obtain the angular coordinates of points on a polysphere
\eqn{\mathcal{S}^{d_1}\times\cdots\times\mathcal{S}^{d_r}}, and vice versa.
}
\examples{
# Check changes of coordinates
polysph_to_angles(angles_to_polysph(rep(pi / 2, 3), d = 2:1), d = 2:1)
angles_to_polysph(polysph_to_angles(x = c(0, 0, 1, 0, 1), d = 2:1), d = 2:1)
}
