% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mixture.R
\name{fit_mixture}
\alias{fit_mixture}
\title{Adjustment Method}
\usage{
fit_mixture(
  formula,
  data,
  family = "gaussian",
  mformula,
  safematches,
  mrate,
  control = list(initbeta = "default", initgamma = "default", fy = "default", maxiter =
    1000, tol = 1e-04, cmaxiter = 1000),
  ...
)
}
\arguments{
\item{formula}{a formula object for the outcome model, with the covariate(s) on
the right of "~" and the response on the left. In the Cox proportional hazards
setting, the response should be provided using the \code{Surv} function and the
covariates should be separated by + signs.}

\item{data}{a data.frame with linked data used in "formula" and "formula.m" (optional)}

\item{family}{the type of regression model ("gaussian" - default, "poisson",
"binomial", "gamma", "cox"). For Generalized Linear Models, standard link functions are
used ("identity" for Gaussian, "log" for Poisson and Gamma, and "logit" for binomial).}

\item{mformula}{a one-sided formula object for the mismatch indicator model, with the
covariates on the right of "~". The default is an intercept-only model corresponding
to a constant mismatch rate)}

\item{safematches}{an indicator variable for safe matches (TRUE : record can be treated as a
correct match and FALSE : record may be mismatched). The default is FALSE for all matches.}

\item{mrate}{the assumed overall mismatch rate (a proportion between 0 and 1). If
not provided, no overall mismatch rate is assumed.}

\item{control}{an optional list variable to customize the initial parameter estimates
("initbeta" for the outcome model and "initgamma" for the mismatch indicator model),
estimated marginal density of the response ("fy"), maximum iterations for the
EM algorithm ("maxiter"), maximum iterations for the subroutine in the constrained
logistic regression function ("cmaxiter"), and convergence tolerance for
the termination of the EM algorithm ("tol").}

\item{...}{the option to directly pass "control" arguments}
}
\value{
a list of results from the function called depending on the "family" specified.
\item{coefficients}{the outcome model coefficient estimates}
\item{match.prob}{the correct match probabilities for all observations}
\item{objective}{a variable that tracks the negative log pseudo-likelihood for all iterations of the EM algorithm.}
\item{family}{the type of (outcome) regression model}
\item{standard.errors}{the estimated standard errors}
\item{m.coefficients}{the correct match model coefficient estimates}
\item{call}{the matched call}
\item{wfit}{an internal-use object for the predict function}
\item{dispersion}{the dispersion parameter estimate when the family is a Generalized
Linear Model}
\item{Lambdahat_0}{the baseline cumulative hazard (using weighted Breslow estimator) when the family is "cox"}
\item{g_Lambdahat_0}{the baseline cumulative hazard for the marginal density of the response variable
(using Nelson-Aalen estimator) when the family is "cox"}
}
\description{
Perform regression adjusted for mismatched data. The function currently supports
Cox Proportional Hazards Regression (right-censored data only) and Generalized
Linear Regression Models (Gaussian, Gamma, Poisson, and Logistic (binary models
only)). Information about the underlying record linkage process can be
incorporated into the method if available (e.g., assumed overall mismatch rate,
safe matches, predictors of match status, or predicted probabilities of correct
matches).
}
\note{
The references below discuss the implemented framework in more detail. The standard
errors are estimated using Louis' method for the "cox" family (Bukke et al., 2023) and
using the sandwich formula otherwise (Slawski et al., 2023).\cr\cr
*Corresponding Author (mslawsk3@gmu.edu)
}
\examples{
## commonness score of first and last names used for linkage
mformula <- ~commf + comml
## hand-linked records are considered "safe" matches
safematches <- ifelse(lifem$hndlnk =="Hand-Linked At Some Level", TRUE, FALSE)
## overall mismatch rate in the data set is assumed to be ~ 0.05
mrate <- 0.05

fit <- fit_mixture(age_at_death ~ poly(unit_yob, 3, raw = TRUE), data = lifem,
                   family = "gaussian", mformula, safematches, mrate)

}
\references{
Slawski, M.*, West, B. T., Bukke, P., Diao, G., Wang, Z., & Ben-David, E. (2023).
A General Framework for Regression with Mismatched Data Based on Mixture Modeling.
Under Review. < \doi{10.48550/arXiv.2306.00909} >\cr

Bukke, P., Ben-David, E., Diao, G., Slawski, M.*, & West, B. T. (2023).
Cox Proportional Hazards Regression Using Linked Data: An Approach Based on Mixture Modelling.
Under Review. \cr

Slawski, M.*, Diao, G., Ben-David, E. (2021). A pseudo-likelihood approach to linear
regression with partially shuffled data. Journal of Computational and Graphical
Statistics. 30(4), 991-1003 < \doi{10.1080/10618600.2020.1870482} >
}
