% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload.R
\name{upload}
\alias{upload}
\alias{ps_upload_file}
\alias{ps_upload_redist}
\alias{ps_upload_shp}
\title{Upload to PlanScore}
\usage{
ps_upload_file(
  file,
  description = NULL,
  incumbents = NULL,
  model_version = NULL,
  library_metadata = NULL,
  temporary = TRUE
)

ps_upload_redist(map, plans, draw, ...)

ps_upload_shp(shp, ...)
}
\arguments{
\item{file}{file to upload, one of a geojson, block assignment file, or zipped shape file}

\item{description}{text for plan description}

\item{incumbents}{Incumbent party, one of \code{'D'} (Democrat), \code{'R'} (Republican),
or \code{'O'} (Open) for each district. Assumes \code{'O'} if none is provided.#'}

\item{model_version}{character model version to use. Available options are listed by \code{\link[=ps_model_versions]{ps_model_versions()}}.}

\item{library_metadata}{Any additional data to be passed through for possible later use.
For advanced use: Should likely be left \code{NULL}.}

\item{temporary}{Should a temporary PlanScore upload be used? Default is TRUE.}

\item{map}{a \code{redist_map} object}

\item{plans}{a \code{redist_plans} object}

\item{draw}{the draw to use from \code{plans}}

\item{...}{arguments to pass on to \code{ps_upload_file()}}

\item{shp}{an \code{sf} shape to upload, where each entry is a district}
}
\value{
list of links to index and plan, on success
}
\description{
Upload to PlanScore
}
\examples{
\dontshow{if (planscorer::ps_has_key()) withAutoprint(\{ # examplesIf}
# Requires API Key
file <- system.file('extdata/null-plan-incumbency.geojson', package = 'planscorer')
ps_upload_file(file)
\dontshow{\}) # examplesIf}
}
\concept{upload}
