% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mySum.R
\name{mySum}
\alias{mySum}
\title{My Sum.}
\usage{
mySum(data)
}
\arguments{
\item{data}{dataframe}
}
\value{
Modified row sum to set row sum to be missing when all values in the
row are missing (\code{NA}).
}
\description{
Compute a row sum and retain \code{NA}s when all values in the row are
\code{NA}.
}
\details{
Compute a row sum and set the row sum to be missing (not zero) when all
values in the row are missing (\code{NA}).
}
\examples{
# Prepare Data
df <- data.frame(item1 = rnorm(1000), item2 = rnorm(1000), item3 = rnorm(1000))
df[sample(1:nrow(df), size = 100), c("item1","item2","item3")] <- NA

# Calculate Missingness-Adjusted Row Sum
df$sum <- mySum(df)
}
\seealso{
Other computations: 
\code{\link{Mode}()},
\code{\link{meanSum}()}
}
\concept{computations}
