% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_milano.R
\name{cluster_milano}
\alias{cluster_milano}
\title{cluster Milano}
\usage{
cluster_milano(vertex, edge_list, seed = NULL)
}
\arguments{
\item{vertex}{the vertices of the graph, whose label are integers and they must be consistent with the edge sets.}

\item{edge_list}{the graph edge list in the form of an integer matrix with two columns.}

\item{seed}{As some steps of the algorithm are random, users may experiments with different seeds of random numbers.}
}
\value{
A list containing:
\describe{
\item{membeship}{The optimal vertex partition.}
\item{value}{The null-adjusted persistence of the partition.}
\item{seed}{The used seed to generate random numbers.}
}
}
\description{
Calculates the partition with maximum global null-adjuted persistence.
}
\examples{
library(persistence)
library(igraph)

edg = c(1, 2, 1, 3, 1, 4, 2, 3, 3, 4, 4, 5, 5, 6, 5, 7, 5, 8, 5, 9, 6, 7, 6, 8, 7, 9, 8, 9)
print(length(edg) / 2.0)
vertex = unique(edg)
edg = t(matrix(as.integer(edg), nrow = 2 ))
rete <- graph_from_edgelist(edg, directed = FALSE)
plot(rete)
seed <- sample(1:as.integer(.Machine$integer.max),1, replace= FALSE)
r = cluster_milano(vertex, edg, seed=seed)
print(paste("The optimal null-adjusted persistence is: ", r$measure))
print(paste("The optimal persistence probability is: ", r$measure + 1))


}
