% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpbox.R
\name{qpbox}
\alias{qpbox}
\alias{qpbox,pbox-method}
\title{Query the probabilistic space of a pbox object.}
\usage{
qpbox(
  pbx,
  mj = "character",
  co = "character",
  lower.tail = TRUE,
  fixed = FALSE,
  CI = FALSE,
  iter = 1000
)

\S4method{qpbox}{pbox}(
  pbx,
  mj = "character",
  co = "character",
  lower.tail = TRUE,
  fixed = FALSE,
  CI = FALSE,
  iter = 1000
)
}
\arguments{
\item{pbx}{An object of class \code{pbox} from which to query the probabilistic space.}

\item{mj}{A character string specifying the marginal and or joint distribution of the variable.
It must specify the variable and the value in the format 'Var:Val'.}

\item{co}{A character string specifying the marginal and conditional distribution of the variable.
It must specify the variable and the value in the format 'Var:Val'.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are calculated for the area to the right of the specified value.}

\item{fixed}{Logical; if TRUE, calculates conditional probabilities with conditions treated as fixed.}

\item{CI}{Logical; if TRUE, calculates bootstrap confidence intervals.}

\item{iter}{Integer; the number of replications for the confidence interval calculation. Default is 1000.}
}
\value{
Estimated probabilities as a numeric value or a named vector including confidence intervals if requested.
}
\description{
This function queries the probabilistic space of a pbox object to calculate probabilities
associated with specific marginal or conditional distributions. It supports conditional
probability calculations and can optionally estimate confidence intervals through bootstrapping.

This method processes the \code{pbox} object to compute probabilities based on the specified marginal
and conditional parameters. It handles both simple probability calculations and complex queries involving
joint and conditional distributions, with an option for bootstrap confidence interval estimation.
}
\examples{
  data("SEAex")
  pbx <- set_pbox(SEAex)
  # Get marginal distribution
  qpbox(pbx, mj="Malaysia:33")
  # Get conditional distribution
  qpbox(pbx, mj="Malaysia:33 & Vietnam:31", co="avgRegion:26")
}
