% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_pbox.R
\name{modify_pbox}
\alias{modify_pbox}
\alias{modify_pbox,ANY-method}
\title{Modify Parameters Box}
\usage{
modify_pbox(all_parms, params_list, sigma = 0.05, range = seq(-3, 3, 1))

\S4method{modify_pbox}{ANY}(all_parms, params_list, sigma = 0.05, range = seq(-3, 3, 1))
}
\arguments{
\item{all_parms}{nested list of parameters from the pbox object.}

\item{params_list}{Named list where each name corresponds to a variable in the dataset
and the value is a vector of parameter names to modify (e.g. list(Vietnam="mu")).}

\item{sigma}{Standard deviation used for calculating parameter deviations.}

\item{range}{Range values for generating deviations.}
}
\value{
Modified list of parameters.
}
\description{
Internal method to modify specific parameters in a nested list structure by applying deviations.
}
\examples{
some_distr<-list(A=list(mu = 31.07, sigma = 0.28),
B=list(mu = 34.4, sigma = 0.98, nu = 1.7),
C=list(mu = 31.4, sigma = 0.34),
D=list(mu = 25.6, sigma = 0.24))
modify_pbox(some_distr, list(A = "mu"))
}
