% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_copy_backup}
\alias{fsx_copy_backup}
\title{Copies an existing backup within the same Amazon Web Services account to
another Amazon Web Services Region (cross-Region copy) or within the
same Amazon Web Services Region (in-Region copy)}
\usage{
fsx_copy_backup(
  ClientRequestToken = NULL,
  SourceBackupId,
  SourceRegion = NULL,
  KmsKeyId = NULL,
  CopyTags = NULL,
  Tags = NULL
)
}
\arguments{
\item{ClientRequestToken}{}

\item{SourceBackupId}{[required] The ID of the source backup. Specifies the ID of the backup that's being
copied.}

\item{SourceRegion}{The source Amazon Web Services Region of the backup. Specifies the
Amazon Web Services Region from which the backup is being copied. The
source and destination Regions must be in the same Amazon Web Services
partition. If you don't specify a Region, \code{SourceRegion} defaults to the
Region where the request is sent from (in-Region copy).}

\item{KmsKeyId}{}

\item{CopyTags}{A Boolean flag indicating whether tags from the source backup should be
copied to the backup copy. This value defaults to \code{false}.

If you set \code{CopyTags} to \code{true} and the source backup has existing tags,
you can use the \code{Tags} parameter to create new tags, provided that the
sum of the source backup tags and the new tags doesn't exceed 50. Both
sets of tags are merged. If there are tag conflicts (for example, two
tags with the same key but different values), the tags created with the
\code{Tags} parameter take precedence.}

\item{Tags}{}
}
\description{
Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.

See \url{https://www.paws-r-sdk.com/docs/fsx_copy_backup/} for full documentation.
}
\keyword{internal}
