% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssoadmin_operations.R
\name{ssoadmin_put_application_assignment_configuration}
\alias{ssoadmin_put_application_assignment_configuration}
\title{Configure how users gain access to an application}
\usage{
ssoadmin_put_application_assignment_configuration(
  ApplicationArn,
  AssignmentRequired
)
}
\arguments{
\item{ApplicationArn}{[required] Specifies the ARN of the application. For more information about ARNs,
see Amazon Resource Names (ARNs) and Amazon Web Services Service
Namespaces in the \emph{Amazon Web Services General Reference}.}

\item{AssignmentRequired}{[required] If \code{AssignmentsRequired} is \code{true} (default value), users don’t have
access to the application unless an assignment is created using the
\href{https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html}{CreateApplicationAssignment API}.
If \code{false}, all users have access to the application.}
}
\description{
Configure how users gain access to an application. If \code{AssignmentsRequired} is \code{true} (default value), users don’t have access to the application unless an assignment is created using the \href{https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html}{CreateApplicationAssignment API}. If \code{false}, all users have access to the application. If an assignment is created using \code{\link[=ssoadmin_create_application_assignment]{create_application_assignment}}., the user retains access if \code{AssignmentsRequired} is set to \code{true}.

See \url{https://www.paws-r-sdk.com/docs/ssoadmin_put_application_assignment_configuration/} for full documentation.
}
\keyword{internal}
