% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssoadmin_operations.R
\name{ssoadmin_list_applications}
\alias{ssoadmin_list_applications}
\title{Lists all applications associated with the instance of IAM Identity
Center}
\usage{
ssoadmin_list_applications(
  Filter = NULL,
  InstanceArn,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Filter}{Filters response results.}

\item{InstanceArn}{[required] The ARN of the IAM Identity Center application under which the operation
will run. For more information about ARNs, see Amazon Resource Names
(ARNs) and Amazon Web Services Service Namespaces in the \emph{Amazon Web
Services General Reference}.}

\item{MaxResults}{Specifies the total number of results that you want included in each
response. If additional items exist beyond the number you specify, the
\code{NextToken} response element is returned with a value (not null).
Include the specified value as the \code{NextToken} request parameter in the
next call to the operation to get the next set of results. Note that the
service might return fewer results than the maximum even when there are
more results available. You should check \code{NextToken} after every
operation to ensure that you receive all of the results.}

\item{NextToken}{Specifies that you want to receive the next page of results. Valid only
if you received a \code{NextToken} response in the previous request. If you
did, it indicates that more output is available. Set this parameter to
the value provided by the previous call's \code{NextToken} response to
request the next page of results.}
}
\description{
Lists all applications associated with the instance of IAM Identity Center. When listing applications for an instance in the management account, member accounts must use the \code{applicationAccount} parameter to filter the list to only applications created from that account.

See \url{https://www.paws-r-sdk.com/docs/ssoadmin_list_applications/} for full documentation.
}
\keyword{internal}
