% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securitylake_operations.R
\name{securitylake_create_data_lake}
\alias{securitylake_create_data_lake}
\title{Initializes an Amazon Security Lake instance with the provided (or
default) configuration}
\usage{
securitylake_create_data_lake(
  configurations,
  metaStoreManagerRoleArn,
  tags = NULL
)
}
\arguments{
\item{configurations}{[required] Specify the Region or Regions that will contribute data to the rollup
region.}

\item{metaStoreManagerRoleArn}{[required] The Amazon Resource Name (ARN) used to create and update the Glue table.
This table contains partitions generated by the ingestion and
normalization of Amazon Web Services log sources and custom sources.}

\item{tags}{An array of objects, one for each tag to associate with the data lake
configuration. For each tag, you must specify both a tag key and a tag
value. A tag value cannot be null, but it can be an empty string.}
}
\description{
Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions. To specify particular Regions, configure these Regions using the \code{configurations} parameter. If you have already enabled Security Lake in a Region when you call this command, the command will update the Region if you provide new configuration parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up the data lake in the Region with the specified configurations.

See \url{https://www.paws-r-sdk.com/docs/securitylake_create_data_lake/} for full documentation.
}
\keyword{internal}
