% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_disable_sso}
\alias{directoryservice_disable_sso}
\title{Disables single-sign on for a directory}
\usage{
directoryservice_disable_sso(DirectoryId, UserName = NULL, Password = NULL)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory for which to disable single-sign on.}

\item{UserName}{The username of an alternate account to use to disable single-sign on.
This is only used for AD Connector directories. This account must have
privileges to remove a service principal name.

If the AD Connector service account does not have privileges to remove a
service principal name, you can specify an alternate account with the
\emph{UserName} and \emph{Password} parameters. These credentials are only used to
disable single sign-on and are not stored by the service. The AD
Connector service account is not changed.}

\item{Password}{The password of an alternate account to use to disable single-sign on.
This is only used for AD Connector directories. For more information,
see the \emph{UserName} parameter.}
}
\description{
Disables single-sign on for a directory.

See \url{https://www.paws-r-sdk.com/docs/directoryservice_disable_sso/} for full documentation.
}
\keyword{internal}
