# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Cognito Identity Provider
#'
#' @description
#' With the Amazon Cognito user pools API, you can configure user pools and
#' authenticate users. To authenticate users from third-party identity
#' providers (IdPs) in this API, you can [link IdP users to native user
#' profiles](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation-consolidate-users.html).
#' Learn more about the authentication and authorization of federated users
#' at [Adding user pool sign-in through a third
#' party](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html)
#' and in the [User pool federation endpoints and hosted UI
#' reference](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-userpools-server-contract-reference.html).
#' 
#' This API reference provides detailed information about API operations
#' and object types in Amazon Cognito.
#' 
#' Along with resource management operations, the Amazon Cognito user pools
#' API includes classes of operations and authorization models for
#' client-side and server-side authentication of users. You can interact
#' with operations in the Amazon Cognito user pools API as any of the
#' following subjects.
#' 
#' 1.  An administrator who wants to configure user pools, app clients,
#'     users, groups, or other user pool functions.
#' 
#' 2.  A server-side app, like a web application, that wants to use its
#'     Amazon Web Services privileges to manage, authenticate, or authorize
#'     a user.
#' 
#' 3.  A client-side app, like a mobile app, that wants to make
#'     unauthenticated requests to manage, authenticate, or authorize a
#'     user.
#' 
#' For more information, see [Using the Amazon Cognito user pools API and
#' user pool
#' endpoints](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-public-server-side.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' With your Amazon Web Services SDK, you can build the logic to support
#' operational flows in every use case for this API. You can also make
#' direct REST API requests to [Amazon Cognito user pools service
#' endpoints](https://docs.aws.amazon.com/general/latest/gr/cognito_identity.html#cognito_identity_your_user_pools_region).
#' The following links can get you started with the
#' `CognitoIdentityProvider` client in other supported Amazon Web Services
#' SDKs.
#' 
#' -   [Amazon Web Services Command Line
#'     Interface](https://docs.aws.amazon.com/cli/latest/reference/cognito-idp/#cli-aws-cognito-idp)
#' 
#' -   [Amazon Web Services SDK for
#'     .NET](https://docs.aws.amazon.com/sdkfornet/v3/apidocs/items/CognitoIdentityProvider/TCognitoIdentityProviderClient.html)
#' 
#' -   [Amazon Web Services SDK for
#'     C++](https://sdk.amazonaws.com/cpp/api/LATEST/aws-cpp-sdk-cognito-idp/html/class_aws_1_1_cognito_identity_provider_1_1_cognito_identity_provider_client.html)
#' 
#' -   [Amazon Web Services SDK for
#'     Go](https://docs.aws.amazon.com/sdk-for-go/api/service/cognitoidentityprovider/#CognitoIdentityProvider)
#' 
#' -   [Amazon Web Services SDK for Java
#'     V2](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/cognitoidentityprovider/CognitoIdentityProviderClient.html)
#' 
#' -   [Amazon Web Services SDK for
#'     JavaScript](https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/CognitoIdentityServiceProvider.html)
#' 
#' -   [Amazon Web Services SDK for PHP
#'     V3](https://docs.aws.amazon.com/aws-sdk-php/v3/api/api-cognito-idp-2016-04-18.html)
#' 
#' -   [Amazon Web Services SDK for
#'     Python](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/cognito-idp.html)
#' 
#' -   [Amazon Web Services SDK for Ruby
#'     V3](https://docs.aws.amazon.com/sdk-for-ruby/v3/api/Aws/CognitoIdentityProvider/Client.html)
#' 
#' -   [Amazon Web Services SDK for
#'     Kotlin](https://sdk.amazonaws.com/kotlin/api/latest/cognitoidentityprovider/aws.sdk.kotlin.services.cognitoidentityprovider/-cognito-identity-provider-client/index.html)
#' 
#' To get started with an Amazon Web Services SDK, see [Tools to Build on
#' Amazon Web Services](https://aws.amazon.com/developer/tools/). For
#' example actions and scenarios, see [Code examples for Amazon Cognito
#' Identity Provider using Amazon Web Services
#' SDKs](https://docs.aws.amazon.com/cognito/latest/developerguide/service_code_examples_cognito-identity-provider.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- cognitoidentityprovider(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cognitoidentityprovider()
#' svc$add_custom_attributes(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cognitoidentityprovider_add_custom_attributes]{add_custom_attributes} \tab Adds additional user attributes to the user pool schema\cr
#'  \link[=cognitoidentityprovider_admin_add_user_to_group]{admin_add_user_to_group} \tab Adds a user to a group\cr
#'  \link[=cognitoidentityprovider_admin_confirm_sign_up]{admin_confirm_sign_up} \tab Confirms user sign-up as an administrator\cr
#'  \link[=cognitoidentityprovider_admin_create_user]{admin_create_user} \tab Creates a new user in the specified user pool\cr
#'  \link[=cognitoidentityprovider_admin_delete_user]{admin_delete_user} \tab Deletes a user profile in your user pool\cr
#'  \link[=cognitoidentityprovider_admin_delete_user_attributes]{admin_delete_user_attributes} \tab Deletes attribute values from a user\cr
#'  \link[=cognitoidentityprovider_admin_disable_provider_for_user]{admin_disable_provider_for_user} \tab Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP)\cr
#'  \link[=cognitoidentityprovider_admin_disable_user]{admin_disable_user} \tab Deactivates a user profile and revokes all access tokens for the user\cr
#'  \link[=cognitoidentityprovider_admin_enable_user]{admin_enable_user} \tab Activate sign-in for a user profile that previously had sign-in access disabled\cr
#'  \link[=cognitoidentityprovider_admin_forget_device]{admin_forget_device} \tab Forgets, or deletes, a remembered device from a user's profile\cr
#'  \link[=cognitoidentityprovider_admin_get_device]{admin_get_device} \tab Given the device key, returns details for a user' device\cr
#'  \link[=cognitoidentityprovider_admin_get_user]{admin_get_user} \tab Given the username, returns details about a user profile in a user pool\cr
#'  \link[=cognitoidentityprovider_admin_initiate_auth]{admin_initiate_auth} \tab Starts sign-in for applications with a server-side component, for example a traditional web application\cr
#'  \link[=cognitoidentityprovider_admin_link_provider_for_user]{admin_link_provider_for_user} \tab Links an existing user account in a user pool (DestinationUser) to an identity from an external IdP (SourceUser) based on a specified attribute name and value from the external IdP\cr
#'  \link[=cognitoidentityprovider_admin_list_devices]{admin_list_devices} \tab Lists a user's registered devices\cr
#'  \link[=cognitoidentityprovider_admin_list_groups_for_user]{admin_list_groups_for_user} \tab Lists the groups that a user belongs to\cr
#'  \link[=cognitoidentityprovider_admin_list_user_auth_events]{admin_list_user_auth_events} \tab Requests a history of user activity and any risks detected as part of Amazon Cognito threat protection\cr
#'  \link[=cognitoidentityprovider_admin_remove_user_from_group]{admin_remove_user_from_group} \tab Given a username and a group name\cr
#'  \link[=cognitoidentityprovider_admin_reset_user_password]{admin_reset_user_password} \tab Resets the specified user's password in a user pool\cr
#'  \link[=cognitoidentityprovider_admin_respond_to_auth_challenge]{admin_respond_to_auth_challenge} \tab Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication that bypasses MFA, or for a custom authentication challenge\cr
#'  \link[=cognitoidentityprovider_admin_set_user_mfa_preference]{admin_set_user_mfa_preference} \tab Sets the user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred\cr
#'  \link[=cognitoidentityprovider_admin_set_user_password]{admin_set_user_password} \tab Sets the specified user's password in a user pool\cr
#'  \link[=cognitoidentityprovider_admin_set_user_settings]{admin_set_user_settings} \tab This action is no longer supported\cr
#'  \link[=cognitoidentityprovider_admin_update_auth_event_feedback]{admin_update_auth_event_feedback} \tab Provides feedback for an authentication event indicating if it was from a valid user\cr
#'  \link[=cognitoidentityprovider_admin_update_device_status]{admin_update_device_status} \tab Updates the status of a user's device so that it is marked as remembered or not remembered for the purpose of device authentication\cr
#'  \link[=cognitoidentityprovider_admin_update_user_attributes]{admin_update_user_attributes} \tab This action might generate an SMS text message\cr
#'  \link[=cognitoidentityprovider_admin_user_global_sign_out]{admin_user_global_sign_out} \tab Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user\cr
#'  \link[=cognitoidentityprovider_associate_software_token]{associate_software_token} \tab Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response\cr
#'  \link[=cognitoidentityprovider_change_password]{change_password} \tab Changes the password for a specified user in a user pool\cr
#'  \link[=cognitoidentityprovider_complete_web_authn_registration]{complete_web_authn_registration} \tab Completes registration of a passkey authenticator for the current user\cr
#'  \link[=cognitoidentityprovider_confirm_device]{confirm_device} \tab Confirms a device that a user wants to remember\cr
#'  \link[=cognitoidentityprovider_confirm_forgot_password]{confirm_forgot_password} \tab This public API operation accepts a confirmation code that Amazon Cognito sent to a user and accepts a new password for that user\cr
#'  \link[=cognitoidentityprovider_confirm_sign_up]{confirm_sign_up} \tab This public API operation submits a code that Amazon Cognito sent to your user when they signed up in your user pool via the SignUp API operation\cr
#'  \link[=cognitoidentityprovider_create_group]{create_group} \tab Creates a new group in the specified user pool\cr
#'  \link[=cognitoidentityprovider_create_identity_provider]{create_identity_provider} \tab Adds a configuration and trust relationship between a third-party identity provider (IdP) and a user pool\cr
#'  \link[=cognitoidentityprovider_create_managed_login_branding]{create_managed_login_branding} \tab Creates a new set of branding settings for a user pool style and associates it with an app client\cr
#'  \link[=cognitoidentityprovider_create_resource_server]{create_resource_server} \tab Creates a new OAuth2\cr
#'  \link[=cognitoidentityprovider_create_user_import_job]{create_user_import_job} \tab Creates a user import job\cr
#'  \link[=cognitoidentityprovider_create_user_pool]{create_user_pool} \tab This action might generate an SMS text message\cr
#'  \link[=cognitoidentityprovider_create_user_pool_client]{create_user_pool_client} \tab Creates an app client in a user pool\cr
#'  \link[=cognitoidentityprovider_create_user_pool_domain]{create_user_pool_domain} \tab A user pool domain hosts managed login, an authorization server and web server for authentication in your application\cr
#'  \link[=cognitoidentityprovider_delete_group]{delete_group} \tab Deletes a group from the specified user pool\cr
#'  \link[=cognitoidentityprovider_delete_identity_provider]{delete_identity_provider} \tab Deletes a user pool identity provider (IdP)\cr
#'  \link[=cognitoidentityprovider_delete_managed_login_branding]{delete_managed_login_branding} \tab Deletes a managed login branding style\cr
#'  \link[=cognitoidentityprovider_delete_resource_server]{delete_resource_server} \tab Deletes a resource server\cr
#'  \link[=cognitoidentityprovider_delete_user]{delete_user} \tab Self-deletes a user profile\cr
#'  \link[=cognitoidentityprovider_delete_user_attributes]{delete_user_attributes} \tab Self-deletes attributes for a user\cr
#'  \link[=cognitoidentityprovider_delete_user_pool]{delete_user_pool} \tab Deletes a user pool\cr
#'  \link[=cognitoidentityprovider_delete_user_pool_client]{delete_user_pool_client} \tab Deletes a user pool app client\cr
#'  \link[=cognitoidentityprovider_delete_user_pool_domain]{delete_user_pool_domain} \tab Given a user pool ID and domain identifier, deletes a user pool domain\cr
#'  \link[=cognitoidentityprovider_delete_web_authn_credential]{delete_web_authn_credential} \tab Deletes a registered passkey, or webauthN, authenticator for the currently signed-in user\cr
#'  \link[=cognitoidentityprovider_describe_identity_provider]{describe_identity_provider} \tab Given a user pool ID and identity provider (IdP) name, returns details about the IdP\cr
#'  \link[=cognitoidentityprovider_describe_managed_login_branding]{describe_managed_login_branding} \tab Given the ID of a managed login branding style, returns detailed information about the style\cr
#'  \link[=cognitoidentityprovider_describe_managed_login_branding_by_client]{describe_managed_login_branding_by_client} \tab Given the ID of a user pool app client, returns detailed information about the style assigned to the app client\cr
#'  \link[=cognitoidentityprovider_describe_resource_server]{describe_resource_server} \tab Describes a resource server\cr
#'  \link[=cognitoidentityprovider_describe_risk_configuration]{describe_risk_configuration} \tab Given an app client or user pool ID where threat protection is configured, describes the risk configuration\cr
#'  \link[=cognitoidentityprovider_describe_user_import_job]{describe_user_import_job} \tab Describes a user import job\cr
#'  \link[=cognitoidentityprovider_describe_user_pool]{describe_user_pool} \tab Given a user pool ID, returns configuration information\cr
#'  \link[=cognitoidentityprovider_describe_user_pool_client]{describe_user_pool_client} \tab Given an app client ID, returns configuration information\cr
#'  \link[=cognitoidentityprovider_describe_user_pool_domain]{describe_user_pool_domain} \tab Given a user pool domain name, returns information about the domain configuration\cr
#'  \link[=cognitoidentityprovider_forget_device]{forget_device} \tab Forgets the specified device\cr
#'  \link[=cognitoidentityprovider_forgot_password]{forgot_password} \tab Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password\cr
#'  \link[=cognitoidentityprovider_get_csv_header]{get_csv_header} \tab Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job\cr
#'  \link[=cognitoidentityprovider_get_device]{get_device} \tab Gets the device\cr
#'  \link[=cognitoidentityprovider_get_group]{get_group} \tab Gets a group\cr
#'  \link[=cognitoidentityprovider_get_identity_provider_by_identifier]{get_identity_provider_by_identifier} \tab Gets the specified IdP\cr
#'  \link[=cognitoidentityprovider_get_log_delivery_configuration]{get_log_delivery_configuration} \tab Gets the logging configuration of a user pool\cr
#'  \link[=cognitoidentityprovider_get_signing_certificate]{get_signing_certificate} \tab This method takes a user pool ID, and returns the signing certificate\cr
#'  \link[=cognitoidentityprovider_get_ui_customization]{get_ui_customization} \tab Gets the user interface (UI) Customization information for a particular app client's app UI, if any such information exists for the client\cr
#'  \link[=cognitoidentityprovider_get_user]{get_user} \tab Gets the user attributes and metadata for a user\cr
#'  \link[=cognitoidentityprovider_get_user_attribute_verification_code]{get_user_attribute_verification_code} \tab Generates a user attribute verification code for the specified attribute name\cr
#'  \link[=cognitoidentityprovider_get_user_auth_factors]{get_user_auth_factors} \tab Lists the authentication options for the currently signed-in user\cr
#'  \link[=cognitoidentityprovider_get_user_pool_mfa_config]{get_user_pool_mfa_config} \tab Gets the user pool multi-factor authentication (MFA) configuration\cr
#'  \link[=cognitoidentityprovider_global_sign_out]{global_sign_out} \tab Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user\cr
#'  \link[=cognitoidentityprovider_initiate_auth]{initiate_auth} \tab Initiates sign-in for a user in the Amazon Cognito user directory\cr
#'  \link[=cognitoidentityprovider_list_devices]{list_devices} \tab Lists the sign-in devices that Amazon Cognito has registered to the current user\cr
#'  \link[=cognitoidentityprovider_list_groups]{list_groups} \tab Lists the groups associated with a user pool\cr
#'  \link[=cognitoidentityprovider_list_identity_providers]{list_identity_providers} \tab Lists information about all IdPs for a user pool\cr
#'  \link[=cognitoidentityprovider_list_resource_servers]{list_resource_servers} \tab Lists the resource servers for a user pool\cr
#'  \link[=cognitoidentityprovider_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that are assigned to an Amazon Cognito user pool\cr
#'  \link[=cognitoidentityprovider_list_user_import_jobs]{list_user_import_jobs} \tab Lists user import jobs for a user pool\cr
#'  \link[=cognitoidentityprovider_list_user_pool_clients]{list_user_pool_clients} \tab Lists the clients that have been created for the specified user pool\cr
#'  \link[=cognitoidentityprovider_list_user_pools]{list_user_pools} \tab Lists the user pools associated with an Amazon Web Services account\cr
#'  \link[=cognitoidentityprovider_list_users]{list_users} \tab Lists users and their basic details in a user pool\cr
#'  \link[=cognitoidentityprovider_list_users_in_group]{list_users_in_group} \tab Lists the users in the specified group\cr
#'  \link[=cognitoidentityprovider_list_web_authn_credentials]{list_web_authn_credentials} \tab Generates a list of the current user's registered passkey, or webauthN, credentials\cr
#'  \link[=cognitoidentityprovider_resend_confirmation_code]{resend_confirmation_code} \tab Resends the confirmation (for confirmation of registration) to a specific user in the user pool\cr
#'  \link[=cognitoidentityprovider_respond_to_auth_challenge]{respond_to_auth_challenge} \tab Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for device authentication that bypasses MFA, or for a custom authentication challenge\cr
#'  \link[=cognitoidentityprovider_revoke_token]{revoke_token} \tab Revokes all of the access tokens generated by, and at the same time as, the specified refresh token\cr
#'  \link[=cognitoidentityprovider_set_log_delivery_configuration]{set_log_delivery_configuration} \tab Sets up or modifies the logging configuration of a user pool\cr
#'  \link[=cognitoidentityprovider_set_risk_configuration]{set_risk_configuration} \tab Configures actions on detected risks\cr
#'  \link[=cognitoidentityprovider_set_ui_customization]{set_ui_customization} \tab Sets the user interface (UI) customization information for a user pool's built-in app UI\cr
#'  \link[=cognitoidentityprovider_set_user_mfa_preference]{set_user_mfa_preference} \tab Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred\cr
#'  \link[=cognitoidentityprovider_set_user_pool_mfa_config]{set_user_pool_mfa_config} \tab Sets the user pool multi-factor authentication (MFA) and passkey configuration\cr
#'  \link[=cognitoidentityprovider_set_user_settings]{set_user_settings} \tab This action is no longer supported\cr
#'  \link[=cognitoidentityprovider_sign_up]{sign_up} \tab Registers the user in the specified user pool and creates a user name, password, and user attributes\cr
#'  \link[=cognitoidentityprovider_start_user_import_job]{start_user_import_job} \tab Starts the user import\cr
#'  \link[=cognitoidentityprovider_start_web_authn_registration]{start_web_authn_registration} \tab Requests credential creation options from your user pool for registration of a passkey authenticator\cr
#'  \link[=cognitoidentityprovider_stop_user_import_job]{stop_user_import_job} \tab Stops the user import job\cr
#'  \link[=cognitoidentityprovider_tag_resource]{tag_resource} \tab Assigns a set of tags to an Amazon Cognito user pool\cr
#'  \link[=cognitoidentityprovider_untag_resource]{untag_resource} \tab Removes the specified tags from an Amazon Cognito user pool\cr
#'  \link[=cognitoidentityprovider_update_auth_event_feedback]{update_auth_event_feedback} \tab Provides the feedback for an authentication event, whether it was from a valid user or not\cr
#'  \link[=cognitoidentityprovider_update_device_status]{update_device_status} \tab Updates the device status\cr
#'  \link[=cognitoidentityprovider_update_group]{update_group} \tab Updates the specified group with the specified attributes\cr
#'  \link[=cognitoidentityprovider_update_identity_provider]{update_identity_provider} \tab Updates IdP information for a user pool\cr
#'  \link[=cognitoidentityprovider_update_managed_login_branding]{update_managed_login_branding} \tab Configures the branding settings for a user pool style\cr
#'  \link[=cognitoidentityprovider_update_resource_server]{update_resource_server} \tab Updates the name and scopes of resource server\cr
#'  \link[=cognitoidentityprovider_update_user_attributes]{update_user_attributes} \tab With this operation, your users can update one or more of their attributes with their own credentials\cr
#'  \link[=cognitoidentityprovider_update_user_pool]{update_user_pool} \tab This action might generate an SMS text message\cr
#'  \link[=cognitoidentityprovider_update_user_pool_client]{update_user_pool_client} \tab Updates the specified user pool app client with the specified attributes\cr
#'  \link[=cognitoidentityprovider_update_user_pool_domain]{update_user_pool_domain} \tab A user pool domain hosts managed login, an authorization server and web server for authentication in your application\cr
#'  \link[=cognitoidentityprovider_verify_software_token]{verify_software_token} \tab Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful\cr
#'  \link[=cognitoidentityprovider_verify_user_attribute]{verify_user_attribute} \tab Verifies the specified user attributes in the user pool
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cognitoidentityprovider
#' @export
cognitoidentityprovider <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .cognitoidentityprovider$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cognitoidentityprovider <- list()

.cognitoidentityprovider$operations <- list()

.cognitoidentityprovider$metadata <- list(
  service_name = "cognito-idp",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "cognito-idp.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "cognito-idp.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "cognito-idp.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "cognito-idp.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "cognito-idp.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "cognito-idp.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "cognito-idp.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Cognito Identity Provider",
  api_version = "2016-04-18",
  signing_name = "cognito-idp",
  json_version = "1.1",
  target_prefix = "AWSCognitoIdentityProviderService"
)

.cognitoidentityprovider$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.cognitoidentityprovider$metadata, handlers, config, op)
}
