% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_validate_resource_policy}
\alias{secretsmanager_validate_resource_policy}
\title{Validates that a resource policy does not grant a wide range of
principals access to your secret}
\usage{
secretsmanager_validate_resource_policy(SecretId = NULL, ResourcePolicy)
}
\arguments{
\item{SecretId}{The ARN or name of the secret with the resource-based policy you want to
validate.}

\item{ResourcePolicy}{[required] A JSON-formatted string that contains an Amazon Web Services
resource-based policy. The policy in the string identifies who can
access or manage this secret and its versions. For example policies, see
\href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html}{Permissions policy examples}.}
}
\description{
Validates that a resource policy does not grant a wide range of principals access to your secret. A resource-based policy is optional for secrets.

See \url{https://www.paws-r-sdk.com/docs/secretsmanager_validate_resource_policy/} for full documentation.
}
\keyword{internal}
