% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivschat_operations.R
\name{ivschat_disconnect_user}
\alias{ivschat_disconnect_user}
\title{Disconnects all connections using a specified user ID from a room}
\usage{
ivschat_disconnect_user(roomIdentifier, userId, reason = NULL)
}
\arguments{
\item{roomIdentifier}{[required] Identifier of the room from which the user's clients should be
disconnected. Currently this must be an ARN.}

\item{userId}{[required] ID of the user (connection) to disconnect from the room.}

\item{reason}{Reason for disconnecting the user.}
}
\description{
Disconnects all connections using a specified user ID from a room. This replicates the \href{https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html}{DisconnectUser} WebSocket operation in the Amazon IVS Chat Messaging API.

See \url{https://www.paws-r-sdk.com/docs/ivschat_disconnect_user/} for full documentation.
}
\keyword{internal}
