% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatbot_operations.R
\name{chatbot_create_custom_action}
\alias{chatbot_create_custom_action}
\title{Creates a custom action that can be invoked as an alias or as a button
on a notification}
\usage{
chatbot_create_custom_action(
  Definition,
  AliasName = NULL,
  Attachments = NULL,
  Tags = NULL,
  ClientToken = NULL,
  ActionName
)
}
\arguments{
\item{Definition}{[required] The definition of the command to run when invoked as an alias or as an
action button.}

\item{AliasName}{The name used to invoke this action in a chat channel. For example,
\verb{@aws run my-alias}.}

\item{Attachments}{Defines when this custom action button should be attached to a
notification.}

\item{Tags}{A map of tags assigned to a resource. A tag is a string-to-string map of
key-value pairs.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the SDK.}

\item{ActionName}{[required] The name of the custom action. This name is included in the Amazon
Resource Name (ARN).}
}
\description{
Creates a custom action that can be invoked as an alias or as a button on a notification.

See \url{https://www.paws-r-sdk.com/docs/chatbot_create_custom_action/} for full documentation.
}
\keyword{internal}
