% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_subnet_group}
\alias{rds_create_db_subnet_group}
\title{Creates a new DB subnet group}
\usage{
rds_create_db_subnet_group(
  DBSubnetGroupName,
  DBSubnetGroupDescription,
  SubnetIds,
  Tags = NULL
)
}
\arguments{
\item{DBSubnetGroupName}{[required] The name for the DB subnet group. This value is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain no more than 255 letters, numbers, periods,
underscores, spaces, or hyphens.
\item Must not be default.
\item First character must be a letter.
}

Example: \code{mydbsubnetgroup}}

\item{DBSubnetGroupDescription}{[required] The description for the DB subnet group.}

\item{SubnetIds}{[required] The EC2 Subnet IDs for the DB subnet group.}

\item{Tags}{Tags to assign to the DB subnet group.}
}
\description{
Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.

See \url{https://www.paws-r-sdk.com/docs/rds_create_db_subnet_group/} for full documentation.
}
\keyword{internal}
