% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_restore_table_to_point_in_time}
\alias{dynamodb_restore_table_to_point_in_time}
\title{Restores the specified table to the specified point in time within
EarliestRestorableDateTime and LatestRestorableDateTime}
\usage{
dynamodb_restore_table_to_point_in_time(
  SourceTableArn = NULL,
  SourceTableName = NULL,
  TargetTableName,
  UseLatestRestorableTime = NULL,
  RestoreDateTime = NULL,
  BillingModeOverride = NULL,
  GlobalSecondaryIndexOverride = NULL,
  LocalSecondaryIndexOverride = NULL,
  ProvisionedThroughputOverride = NULL,
  OnDemandThroughputOverride = NULL,
  SSESpecificationOverride = NULL
)
}
\arguments{
\item{SourceTableArn}{The DynamoDB table that will be restored. This value is an Amazon
Resource Name (ARN).}

\item{SourceTableName}{Name of the source table that is being restored.}

\item{TargetTableName}{[required] The name of the new table to which it must be restored to.}

\item{UseLatestRestorableTime}{Restore the table to the latest possible time.
\code{LatestRestorableDateTime} is typically 5 minutes before the current
time.}

\item{RestoreDateTime}{Time in the past to restore the table to.}

\item{BillingModeOverride}{The billing mode of the restored table.}

\item{GlobalSecondaryIndexOverride}{List of global secondary indexes for the restored table. The indexes
provided should match existing secondary indexes. You can choose to
exclude some or all of the indexes at the time of restore.}

\item{LocalSecondaryIndexOverride}{List of local secondary indexes for the restored table. The indexes
provided should match existing secondary indexes. You can choose to
exclude some or all of the indexes at the time of restore.}

\item{ProvisionedThroughputOverride}{Provisioned throughput settings for the restored table.}

\item{OnDemandThroughputOverride}{}

\item{SSESpecificationOverride}{The new server-side encryption settings for the restored table.}
}
\description{
Restores the specified table to the specified point in time within \code{EarliestRestorableDateTime} and \code{LatestRestorableDateTime}. You can restore your table to any point in time in the last 35 days. You can set the recovery period to any value between 1 and 35 days. Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_restore_table_to_point_in_time/} for full documentation.
}
\keyword{internal}
