% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestreamwrite_operations.R
\name{timestreamwrite_create_table}
\alias{timestreamwrite_create_table}
\title{Adds a new table to an existing database in your account}
\usage{
timestreamwrite_create_table(
  DatabaseName,
  TableName,
  RetentionProperties = NULL,
  Tags = NULL,
  MagneticStoreWriteProperties = NULL,
  Schema = NULL
)
}
\arguments{
\item{DatabaseName}{[required] The name of the Timestream database.}

\item{TableName}{[required] The name of the Timestream table.}

\item{RetentionProperties}{The duration for which your time-series data must be stored in the
memory store and the magnetic store.}

\item{Tags}{A list of key-value pairs to label the table.}

\item{MagneticStoreWriteProperties}{Contains properties to set on the table when enabling magnetic store
writes.}

\item{Schema}{The schema of the table.}
}
\description{
Adds a new table to an existing database in your account. In an Amazon Web Services account, table names must be at least unique within each Region if they are in the same database. You might have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. \href{https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html}{Service quotas apply}. See \href{https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html}{code sample} for details.

See \url{https://www.paws-r-sdk.com/docs/timestreamwrite_create_table/} for full documentation.
}
\keyword{internal}
