% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_snapshot_schedules}
\alias{redshift_describe_snapshot_schedules}
\title{Returns a list of snapshot schedules}
\usage{
redshift_describe_snapshot_schedules(
  ClusterIdentifier = NULL,
  ScheduleIdentifier = NULL,
  TagKeys = NULL,
  TagValues = NULL,
  Marker = NULL,
  MaxRecords = NULL
)
}
\arguments{
\item{ClusterIdentifier}{The unique identifier for the cluster whose snapshot schedules you want
to view.}

\item{ScheduleIdentifier}{A unique identifier for a snapshot schedule.}

\item{TagKeys}{The key value for a snapshot schedule tag.}

\item{TagValues}{The value corresponding to the key of the snapshot schedule tag.}

\item{Marker}{A value that indicates the starting point for the next set of response
records in a subsequent request. If a value is returned in a response,
you can retrieve the next set of records by providing this returned
marker value in the \code{marker} parameter and retrying the command. If the
\code{marker} field is empty, all response records have been retrieved for
the request.}

\item{MaxRecords}{The maximum number or response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned \code{marker} value.}
}
\description{
Returns a list of snapshot schedules.

See \url{https://www.paws-r-sdk.com/docs/redshift_describe_snapshot_schedules/} for full documentation.
}
\keyword{internal}
