% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_authorize_snapshot_access}
\alias{redshift_authorize_snapshot_access}
\title{Authorizes the specified Amazon Web Services account to restore the
specified snapshot}
\usage{
redshift_authorize_snapshot_access(
  SnapshotIdentifier = NULL,
  SnapshotArn = NULL,
  SnapshotClusterIdentifier = NULL,
  AccountWithRestoreAccess
)
}
\arguments{
\item{SnapshotIdentifier}{The identifier of the snapshot the account is authorized to restore.}

\item{SnapshotArn}{The Amazon Resource Name (ARN) of the snapshot to authorize access to.}

\item{SnapshotClusterIdentifier}{The identifier of the cluster the snapshot was created from.
\itemize{
\item \emph{If the snapshot to access doesn't exist and the associated IAM
policy doesn't allow access to all (}) snapshots* - This parameter
is required. Otherwise, permissions aren't available to check if the
snapshot exists.
\item \emph{If the snapshot to access exists} - This parameter isn't required.
Redshift can retrieve the cluster identifier and use it to validate
snapshot authorization.
}}

\item{AccountWithRestoreAccess}{[required] The identifier of the Amazon Web Services account authorized to restore
the specified snapshot.

To share a snapshot with Amazon Web Services Support, specify
amazon-redshift-support.}
}
\description{
Authorizes the specified Amazon Web Services account to restore the specified snapshot.

See \url{https://www.paws-r-sdk.com/docs/redshift_authorize_snapshot_access/} for full documentation.
}
\keyword{internal}
