% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_clusters}
\alias{rds_describe_db_clusters}
\title{Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters}
\usage{
rds_describe_db_clusters(
  DBClusterIdentifier = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  IncludeShared = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{The user-supplied DB cluster identifier or the Amazon Resource Name
(ARN) of the DB cluster. If this parameter is specified, information for
only the specific DB cluster is returned. This parameter isn't
case-sensitive.

Constraints:
\itemize{
\item If supplied, must match an existing DB cluster identifier.
}}

\item{Filters}{A filter that specifies one or more DB clusters to describe.

Supported Filters:
\itemize{
\item \code{clone-group-id} - Accepts clone group identifiers. The results list
only includes information about the DB clusters associated with
these clone groups.
\item \code{db-cluster-id} - Accepts DB cluster identifiers and DB cluster
Amazon Resource Names (ARNs). The results list only includes
information about the DB clusters identified by these ARNs.
\item \code{db-cluster-resource-id} - Accepts DB cluster resource identifiers.
The results list will only include information about the DB clusters
identified by these DB cluster resource identifiers.
\item \code{domain} - Accepts Active Directory directory IDs. The results list
only includes information about the DB clusters associated with
these domains.
\item \code{engine} - Accepts engine names. The results list only includes
information about the DB clusters for these engines.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_clusters]{describe_db_clusters}} request. If this
parameter is specified, the response includes only records beyond the
marker, up to the value specified by \code{MaxRecords}.}

\item{IncludeShared}{Specifies whether the output includes information about clusters shared
from other Amazon Web Services accounts.}
}
\description{
Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_db_clusters/} for full documentation.
}
\keyword{internal}
