% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_db_parameter_group}
\alias{neptune_modify_db_parameter_group}
\title{Modifies the parameters of a DB parameter group}
\usage{
neptune_modify_db_parameter_group(DBParameterGroupName, Parameters)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of the DB parameter group.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DBParameterGroup.
}}

\item{Parameters}{[required] An array of parameter names, values, and the apply method for the
parameter update. At least one parameter name, value, and apply method
must be supplied; subsequent arguments are optional. A maximum of 20
parameters can be modified in a single request.

Valid Values (for the application method): \code{immediate | pending-reboot}

You can use the immediate value with dynamic parameters only. You can
use the pending-reboot value for both dynamic and static parameters, and
changes are applied when you reboot the DB instance without failover.}
}
\description{
Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: \code{ParameterName}, \code{ParameterValue}, and \code{ApplyMethod}. A maximum of 20 parameters can be modified in a single request.

See \url{https://www.paws-r-sdk.com/docs/neptune_modify_db_parameter_group/} for full documentation.
}
\keyword{internal}
