% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_delete_db_cluster}
\alias{docdb_delete_db_cluster}
\title{Deletes a previously provisioned cluster}
\usage{
docdb_delete_db_cluster(
  DBClusterIdentifier,
  SkipFinalSnapshot = NULL,
  FinalDBSnapshotIdentifier = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The cluster identifier for the cluster to be deleted. This parameter
isn't case sensitive.

Constraints:
\itemize{
\item Must match an existing \code{DBClusterIdentifier}.
}}

\item{SkipFinalSnapshot}{Determines whether a final cluster snapshot is created before the
cluster is deleted. If \code{true} is specified, no cluster snapshot is
created. If \code{false} is specified, a cluster snapshot is created before
the DB cluster is deleted.

If \code{SkipFinalSnapshot} is \code{false}, you must specify a
\code{FinalDBSnapshotIdentifier} parameter.

Default: \code{false}}

\item{FinalDBSnapshotIdentifier}{The cluster snapshot identifier of the new cluster snapshot created when
\code{SkipFinalSnapshot} is set to \code{false}.

Specifying this parameter and also setting the \code{SkipFinalShapshot}
parameter to \code{true} results in an error.

Constraints:
\itemize{
\item Must be from 1 to 255 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}
}
\description{
Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.

See \url{https://www.paws-r-sdk.com/docs/docdb_delete_db_cluster/} for full documentation.
}
\keyword{internal}
