# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon NeptuneData
#'
#' @description
#' Neptune Data API
#' 
#' The Amazon Neptune data API provides SDK support for more than 40 of
#' Neptune's data operations, including data loading, query execution, data
#' inquiry, and machine learning. It supports the Gremlin and openCypher
#' query languages, and is available in all SDK languages. It automatically
#' signs API requests and greatly simplifies integrating Neptune into your
#' applications.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- neptunedata(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- neptunedata()
#' svc$cancel_gremlin_query(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=neptunedata_cancel_gremlin_query]{cancel_gremlin_query} \tab Cancels a Gremlin query\cr
#'  \link[=neptunedata_cancel_loader_job]{cancel_loader_job} \tab Cancels a specified load job\cr
#'  \link[=neptunedata_cancel_ml_data_processing_job]{cancel_ml_data_processing_job} \tab Cancels a Neptune ML data processing job\cr
#'  \link[=neptunedata_cancel_ml_model_training_job]{cancel_ml_model_training_job} \tab Cancels a Neptune ML model training job\cr
#'  \link[=neptunedata_cancel_ml_model_transform_job]{cancel_ml_model_transform_job} \tab Cancels a specified model transform job\cr
#'  \link[=neptunedata_cancel_open_cypher_query]{cancel_open_cypher_query} \tab Cancels a specified openCypher query\cr
#'  \link[=neptunedata_create_ml_endpoint]{create_ml_endpoint} \tab Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training process constructed\cr
#'  \link[=neptunedata_delete_ml_endpoint]{delete_ml_endpoint} \tab Cancels the creation of a Neptune ML inference endpoint\cr
#'  \link[=neptunedata_delete_propertygraph_statistics]{delete_propertygraph_statistics} \tab Deletes statistics for Gremlin and openCypher (property graph) data\cr
#'  \link[=neptunedata_delete_sparql_statistics]{delete_sparql_statistics} \tab Deletes SPARQL statistics\cr
#'  \link[=neptunedata_execute_fast_reset]{execute_fast_reset} \tab The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data\cr
#'  \link[=neptunedata_execute_gremlin_explain_query]{execute_gremlin_explain_query} \tab Executes a Gremlin Explain query\cr
#'  \link[=neptunedata_execute_gremlin_profile_query]{execute_gremlin_profile_query} \tab Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and produces a profile report as output\cr
#'  \link[=neptunedata_execute_gremlin_query]{execute_gremlin_query} \tab This commands executes a Gremlin query\cr
#'  \link[=neptunedata_execute_open_cypher_explain_query]{execute_open_cypher_explain_query} \tab Executes an openCypher explain request\cr
#'  \link[=neptunedata_execute_open_cypher_query]{execute_open_cypher_query} \tab Executes an openCypher query\cr
#'  \link[=neptunedata_get_engine_status]{get_engine_status} \tab Retrieves the status of the graph database on the host\cr
#'  \link[=neptunedata_get_gremlin_query_status]{get_gremlin_query_status} \tab Gets the status of a specified Gremlin query\cr
#'  \link[=neptunedata_get_loader_job_status]{get_loader_job_status} \tab Gets status information about a specified load job\cr
#'  \link[=neptunedata_get_ml_data_processing_job]{get_ml_data_processing_job} \tab Retrieves information about a specified data processing job\cr
#'  \link[=neptunedata_get_ml_endpoint]{get_ml_endpoint} \tab Retrieves details about an inference endpoint\cr
#'  \link[=neptunedata_get_ml_model_training_job]{get_ml_model_training_job} \tab Retrieves information about a Neptune ML model training job\cr
#'  \link[=neptunedata_get_ml_model_transform_job]{get_ml_model_transform_job} \tab Gets information about a specified model transform job\cr
#'  \link[=neptunedata_get_open_cypher_query_status]{get_open_cypher_query_status} \tab Retrieves the status of a specified openCypher query\cr
#'  \link[=neptunedata_get_propertygraph_statistics]{get_propertygraph_statistics} \tab Gets property graph statistics (Gremlin and openCypher)\cr
#'  \link[=neptunedata_get_propertygraph_stream]{get_propertygraph_stream} \tab Gets a stream for a property graph\cr
#'  \link[=neptunedata_get_propertygraph_summary]{get_propertygraph_summary} \tab Gets a graph summary for a property graph\cr
#'  \link[=neptunedata_get_rdf_graph_summary]{get_rdf_graph_summary} \tab Gets a graph summary for an RDF graph\cr
#'  \link[=neptunedata_get_sparql_statistics]{get_sparql_statistics} \tab Gets RDF statistics (SPARQL)\cr
#'  \link[=neptunedata_get_sparql_stream]{get_sparql_stream} \tab Gets a stream for an RDF graph\cr
#'  \link[=neptunedata_list_gremlin_queries]{list_gremlin_queries} \tab Lists active Gremlin queries\cr
#'  \link[=neptunedata_list_loader_jobs]{list_loader_jobs} \tab Retrieves a list of the loadIds for all active loader jobs\cr
#'  \link[=neptunedata_list_ml_data_processing_jobs]{list_ml_data_processing_jobs} \tab Returns a list of Neptune ML data processing jobs\cr
#'  \link[=neptunedata_list_ml_endpoints]{list_ml_endpoints} \tab Lists existing inference endpoints\cr
#'  \link[=neptunedata_list_ml_model_training_jobs]{list_ml_model_training_jobs} \tab Lists Neptune ML model-training jobs\cr
#'  \link[=neptunedata_list_ml_model_transform_jobs]{list_ml_model_transform_jobs} \tab Returns a list of model transform job IDs\cr
#'  \link[=neptunedata_list_open_cypher_queries]{list_open_cypher_queries} \tab Lists active openCypher queries\cr
#'  \link[=neptunedata_manage_propertygraph_statistics]{manage_propertygraph_statistics} \tab Manages the generation and use of property graph statistics\cr
#'  \link[=neptunedata_manage_sparql_statistics]{manage_sparql_statistics} \tab Manages the generation and use of RDF graph statistics\cr
#'  \link[=neptunedata_start_loader_job]{start_loader_job} \tab Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance\cr
#'  \link[=neptunedata_start_ml_data_processing_job]{start_ml_data_processing_job} \tab Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training\cr
#'  \link[=neptunedata_start_ml_model_training_job]{start_ml_model_training_job} \tab Creates a new Neptune ML model training job\cr
#'  \link[=neptunedata_start_ml_model_transform_job]{start_ml_model_transform_job} \tab Creates a new model transform job
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname neptunedata
#' @export
neptunedata <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .neptunedata$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.neptunedata <- list()

.neptunedata$operations <- list()

.neptunedata$metadata <- list(
  service_name = "neptunedata",
  endpoints = list("*" = list(endpoint = "neptune-db.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "neptune-db.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "neptune-db.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "neptune-db.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "neptune-db.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "neptune-db.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "neptunedata",
  api_version = "2023-08-01",
  signing_name = "neptune-db",
  json_version = "1.1",
  target_prefix = ""
)

.neptunedata$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.neptunedata$metadata, handlers, config, op)
}
