% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_cluster_iam_roles}
\alias{redshift_modify_cluster_iam_roles}
\title{Modifies the list of Identity and Access Management (IAM) roles that can
be used by the cluster to access other Amazon Web Services services}
\usage{
redshift_modify_cluster_iam_roles(
  ClusterIdentifier,
  AddIamRoles = NULL,
  RemoveIamRoles = NULL,
  DefaultIamRoleArn = NULL
)
}
\arguments{
\item{ClusterIdentifier}{[required] The unique identifier of the cluster for which you want to associate or
disassociate IAM roles.}

\item{AddIamRoles}{Zero or more IAM roles to associate with the cluster. The roles must be
in their Amazon Resource Name (ARN) format.}

\item{RemoveIamRoles}{Zero or more IAM roles in ARN format to disassociate from the cluster.}

\item{DefaultIamRoleArn}{The Amazon Resource Name (ARN) for the IAM role that was set as default
for the cluster when the cluster was last modified.}
}
\description{
Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.

See \url{https://www.paws-r-sdk.com/docs/redshift_modify_cluster_iam_roles/} for full documentation.
}
\keyword{internal}
