% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_cluster_to_point_in_time}
\alias{rds_restore_db_cluster_to_point_in_time}
\title{Restores a DB cluster to an arbitrary point in time}
\usage{
rds_restore_db_cluster_to_point_in_time(
  DBClusterIdentifier,
  RestoreType = NULL,
  SourceDBClusterIdentifier = NULL,
  RestoreToTime = NULL,
  UseLatestRestorableTime = NULL,
  Port = NULL,
  DBSubnetGroupName = NULL,
  OptionGroupName = NULL,
  VpcSecurityGroupIds = NULL,
  Tags = NULL,
  KmsKeyId = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  BacktrackWindow = NULL,
  EnableCloudwatchLogsExports = NULL,
  DBClusterParameterGroupName = NULL,
  DeletionProtection = NULL,
  CopyTagsToSnapshot = NULL,
  Domain = NULL,
  DomainIAMRoleName = NULL,
  ScalingConfiguration = NULL,
  EngineMode = NULL,
  DBClusterInstanceClass = NULL,
  StorageType = NULL,
  PubliclyAccessible = NULL,
  Iops = NULL,
  ServerlessV2ScalingConfiguration = NULL,
  NetworkType = NULL,
  SourceDbClusterResourceId = NULL,
  RdsCustomClusterConfiguration = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the new DB cluster to be created.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{RestoreType}{The type of restore to be performed. You can specify one of the
following values:
\itemize{
\item \code{full-copy} - The new DB cluster is restored as a full copy of the
source DB cluster.
\item \code{copy-on-write} - The new DB cluster is restored as a clone of the
source DB cluster.
}

If you don't specify a \code{RestoreType} value, then the new DB cluster is
restored as a full copy of the source DB cluster.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{SourceDBClusterIdentifier}{The identifier of the source DB cluster from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{RestoreToTime}{The date and time to restore the DB cluster to.

Valid Values: Value must be a time in Universal Coordinated Time (UTC)
format

Constraints:
\itemize{
\item Must be before the latest restorable time for the DB instance
\item Must be specified if \code{UseLatestRestorableTime} parameter isn't
provided
\item Can't be specified if the \code{UseLatestRestorableTime} parameter is
enabled
\item Can't be specified if the \code{RestoreType} parameter is \code{copy-on-write}
}

Example: \verb{2015-03-07T23:45:00Z}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{UseLatestRestorableTime}{Specifies whether to restore the DB cluster to the latest restorable
backup time. By default, the DB cluster isn't restored to the latest
restorable backup time.

Constraints: Can't be specified if \code{RestoreToTime} parameter is
provided.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: A value from \code{1150-65535}.

Default: The default port for the engine.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new DB cluster.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mydbsubnetgroup}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{OptionGroupName}{The name of the option group for the new DB cluster.

DB clusters are associated with a default option group that can't be
modified.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new DB cluster belongs to.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Tags}{}

\item{KmsKeyId}{The Amazon Web Services KMS key identifier to use when restoring an
encrypted DB cluster from an encrypted DB cluster.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key. To use a KMS key in a different
Amazon Web Services account, specify the key ARN or alias ARN.

You can restore to a new DB cluster and encrypt the new DB cluster with
a KMS key that is different from the KMS key used to encrypt the source
DB cluster. The new DB cluster is encrypted with the KMS key identified
by the \code{KmsKeyId} parameter.

If you don't specify a value for the \code{KmsKeyId} parameter, then the
following occurs:
\itemize{
\item If the DB cluster is encrypted, then the restored DB cluster is
encrypted using the KMS key that was used to encrypt the source DB
cluster.
\item If the DB cluster isn't encrypted, then the restored DB cluster
isn't encrypted.
}

If \code{DBClusterIdentifier} refers to a DB cluster that isn't encrypted,
then the restore request is rejected.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{EnableIAMDatabaseAuthentication}{Specifies whether to enable mapping of Amazon Web Services Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping isn't enabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide}.

Valid for: Aurora DB clusters only}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}

Valid for: Aurora MySQL DB clusters only}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to CloudWatch
Logs. The values in the list depend on the DB engine being used.

\strong{RDS for MySQL}

Possible values are \code{error}, \code{general}, and \code{slowquery}.

\strong{RDS for PostgreSQL}

Possible values are \code{postgresql} and \code{upgrade}.

\strong{Aurora MySQL}

Possible values are \code{audit}, \code{error}, \code{general}, and \code{slowquery}.

\strong{Aurora PostgreSQL}

Possible value is \code{postgresql}.

For more information about exporting CloudWatch Logs for Amazon RDS, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.

For more information about exporting CloudWatch Logs for Amazon Aurora,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{DBClusterParameterGroupName}{The name of the custom DB cluster parameter group to associate with this
DB cluster.

If the \code{DBClusterParameterGroupName} parameter is omitted, the default
DB cluster parameter group for the specified engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DB cluster parameter
group.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{DeletionProtection}{Specifies whether to enable deletion protection for the DB cluster. The
database can't be deleted when deletion protection is enabled. By
default, deletion protection isn't enabled.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{CopyTagsToSnapshot}{Specifies whether to copy all tags from the restored DB cluster to
snapshots of the restored DB cluster. The default is not to copy them.

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{Domain}{The Active Directory directory ID to restore the DB cluster in. The
domain must be created prior to this operation.

For Amazon Aurora DB clusters, Amazon RDS can use Kerberos
Authentication to authenticate users that connect to the DB cluster. For
more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon Aurora User Guide}.

Valid for: Aurora DB clusters only}

\item{DomainIAMRoleName}{The name of the IAM role to be used when making API calls to the
Directory Service.

Valid for: Aurora DB clusters only}

\item{ScalingConfiguration}{For DB clusters in \code{serverless} DB engine mode, the scaling properties
of the DB cluster.

Valid for: Aurora DB clusters only}

\item{EngineMode}{The engine mode of the new cluster. Specify \code{provisioned} or
\code{serverless}, depending on the type of the cluster you are creating. You
can create an Aurora Serverless v1 clone from a provisioned cluster, or
a provisioned clone from an Aurora Serverless v1 cluster. To create a
clone that is an Aurora Serverless v1 cluster, the original cluster must
be an Aurora Serverless v1 cluster or an encrypted provisioned cluster.

Valid for: Aurora DB clusters only}

\item{DBClusterInstanceClass}{The compute and memory capacity of the each DB instance in the Multi-AZ
DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are
available in all Amazon Web Services Regions, or for all database
engines.

For the full list of DB instance classes, and availability for your
engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB instance class}
in the \emph{Amazon RDS User Guide}.

Valid for: Multi-AZ DB clusters only}

\item{StorageType}{Specifies the storage type to be associated with the DB cluster.

When specified for a Multi-AZ DB cluster, a value for the \code{Iops}
parameter is required.

Valid Values: \code{aurora}, \code{aurora-iopt1} (Aurora DB clusters); \code{io1}
(Multi-AZ DB clusters)

Default: \code{aurora} (Aurora DB clusters); \code{io1} (Multi-AZ DB clusters)

Valid for: Aurora DB clusters and Multi-AZ DB clusters}

\item{PubliclyAccessible}{Specifies whether the DB cluster is publicly accessible.

When the DB cluster is publicly accessible, its Domain Name System (DNS)
endpoint resolves to the private IP address from within the DB cluster's
virtual private cloud (VPC). It resolves to the public IP address from
outside of the DB cluster's VPC. Access to the DB cluster is ultimately
controlled by the security group it uses. That public access is not
permitted if the security group assigned to the DB cluster doesn't
permit it.

When the DB cluster isn't publicly accessible, it is an internal DB
cluster with a DNS name that resolves to a private IP address.

Default: The default behavior varies depending on whether
\code{DBSubnetGroupName} is specified.

If \code{DBSubnetGroupName} isn't specified, and \code{PubliclyAccessible} isn't
specified, the following applies:
\itemize{
\item If the default VPC in the target Region doesn’t have an internet
gateway attached to it, the DB cluster is private.
\item If the default VPC in the target Region has an internet gateway
attached to it, the DB cluster is public.
}

If \code{DBSubnetGroupName} is specified, and \code{PubliclyAccessible} isn't
specified, the following applies:
\itemize{
\item If the subnets are part of a VPC that doesn’t have an internet
gateway attached to it, the DB cluster is private.
\item If the subnets are part of a VPC that has an internet gateway
attached to it, the DB cluster is public.
}

Valid for: Multi-AZ DB clusters only}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for each DB instance in the Multi-AZ DB cluster.

For information about valid IOPS values, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS}{Amazon RDS Provisioned IOPS storage}
in the \emph{Amazon RDS User Guide}.

Constraints: Must be a multiple between .5 and 50 of the storage amount
for the DB instance.

Valid for: Multi-AZ DB clusters only}

\item{ServerlessV2ScalingConfiguration}{}

\item{NetworkType}{The network type of the DB cluster.

Valid Values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}

The network type is determined by the \code{DBSubnetGroup} specified for the
DB cluster. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon Aurora User Guide.}

Valid for: Aurora DB clusters only}

\item{SourceDbClusterResourceId}{The resource ID of the source DB cluster from which to restore.}

\item{RdsCustomClusterConfiguration}{Reserved for future use.}
}
\description{
Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before \code{LatestRestorableTime} for up to \code{BackupRetentionPeriod} days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.

See \url{https://www.paws-r-sdk.com/docs/rds_restore_db_cluster_to_point_in_time/} for full documentation.
}
\keyword{internal}
