% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{select_x_percent}
\alias{select_x_percent}
\title{Select a region of interest within the tunnel}
\usage{
select_x_percent(obj_name, desired_percent = 33, ...)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{desired_percent}{Numeric, the percent of the total length of the tunnel
that will define the region of interest. Measured from the center outwards.}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) in which data outside
the region of interest have been removed.
}
\description{
Select data in the middle X percent of the length of the tunnel
}
\examples{
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                              package = 'pathviewr'))

## Clean the file. It is generally recommended to clean up to the
## "trimmed" step before running rotate_tunnel().
motive_rotated <-
  motive_data \%>\%
  relabel_viewr_axes() \%>\%
  gather_tunnel_data() \%>\%
  trim_tunnel_outliers() \%>\%
  rotate_tunnel()

## Now select the middle 50\% of the tunnel
motive_selected <-
  motive_rotated \%>\%
  select_x_percent(desired_percent = 50)

## Compare the ranges of lengths to see the effect
range(motive_rotated$position_length)
range(motive_selected$position_length)
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
