% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{hierarchical_term_clustering}
\alias{hierarchical_term_clustering}
\title{Hierarchical Clustering of Enriched Terms}
\usage{
hierarchical_term_clustering(
  kappa_mat,
  enrichment_res,
  num_clusters = NULL,
  use_description = FALSE,
  clu_method = "average",
  plot_hmap = FALSE,
  plot_dend = TRUE
)
}
\arguments{
\item{kappa_mat}{matrix of kappa statistics (output of \code{\link{create_kappa_matrix}})}

\item{enrichment_res}{data frame of pathfindR enrichment results. Must-have
columns are 'Term_Description' (if \code{use_description = TRUE}) or 'ID'
(if \code{use_description = FALSE}), 'Down_regulated', and 'Up_regulated'.
If \code{use_active_snw_genes = TRUE}, 'non_Signif_Snw_Genes' must also be
provided.}

\item{num_clusters}{number of clusters to be formed (default = \code{NULL}).
If \code{NULL}, the optimal number of clusters is determined as the number
which yields the highest average silhouette width.}

\item{use_description}{Boolean argument to indicate whether term descriptions
(in the 'Term_Description' column) should be used. (default = \code{FALSE})}

\item{clu_method}{the agglomeration method to be used
(default = 'average', see \code{\link[stats]{hclust}})}

\item{plot_hmap}{boolean to indicate whether to plot the kappa statistics
clustering heatmap or not (default = FALSE)}

\item{plot_dend}{boolean to indicate whether to plot the clustering
dendrogram partitioned into the optimal number of clusters (default = TRUE)}
}
\value{
a vector of clusters for each enriched term in the enrichment results.
}
\description{
Hierarchical Clustering of Enriched Terms
}
\details{
The function initially performs hierarchical clustering
of the enriched terms in \code{enrichment_res} using the kappa statistics
(defining the distance as \code{1 - kappa_statistic}). Next,
the clustering dendrogram is cut into k = 2, 3, ..., n - 1 clusters
(where n is the number of terms). The optimal number of clusters is
determined as the k value which yields the highest average silhouette width.
(if \code{num_clusters} not specified)
}
\examples{
\dontrun{
hierarchical_term_clustering(kappa_mat, enrichment_res)
hierarchical_term_clustering(kappa_mat, enrichment_res, method = 'complete')
}
}
