% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{pls}
\alias{pls}
\title{Partial least squares (PLS)}
\usage{
pls(
  mode = "unknown",
  predictor_prop = NULL,
  num_comp = NULL,
  engine = "mixOmics"
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{predictor_prop}{The maximum proportion of original predictors that can
have \emph{non-zero} coefficients for each PLS component (via regularization).
This value is used for all PLS components for X.}

\item{num_comp}{The number of PLS components to retain.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{pls()} defines a partial least squares model that uses latent variables to
model the data. It is similar to a supervised version of principal component.
This function can fit classification and regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("pls")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
pls(argument = !!value)
}\if{html}{\out{</div>}}
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("pls")}
}
